package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  NextToken,
  TaggableResourceId
}
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(
    resourceId: TaggableResourceId,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListTagsForResourceRequest
      .builder()
      .resourceId(resourceId: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListTagsForResourceRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListTagsForResourceRequest =
      io.github.vigoo.zioaws.organizations.model.ListTagsForResourceRequest(
        resourceIdValue,
        nextTokenValue.map(value => value)
      )
    def resourceIdValue: TaggableResourceId
    def nextTokenValue: Option[NextToken]
    def resourceId: ZIO[Any, Nothing, TaggableResourceId] =
      ZIO.succeed(resourceIdValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListTagsForResourceRequest
  ) extends io.github.vigoo.zioaws.organizations.model.ListTagsForResourceRequest.ReadOnly {
    override def resourceIdValue: TaggableResourceId =
      impl.resourceId(): TaggableResourceId
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListTagsForResourceRequest
  ): io.github.vigoo.zioaws.organizations.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
