package io.github.vigoo.zioaws.organizations.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  MaxResults,
  NextToken
}
import scala.jdk.CollectionConverters.*
final case class ListPoliciesRequest(
    filter: io.github.vigoo.zioaws.organizations.model.PolicyType,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListPoliciesRequest = {
    import ListPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListPoliciesRequest
      .builder()
      .filter(filter.unwrap)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListPoliciesRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListPoliciesRequest
      .wrap(buildAwsValue())
}
object ListPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListPoliciesRequest =
      io.github.vigoo.zioaws.organizations.model.ListPoliciesRequest(
        filterValue,
        nextTokenValue.map(value => value),
        maxResultsValue.map(value => value)
      )
    def filterValue: io.github.vigoo.zioaws.organizations.model.PolicyType
    def nextTokenValue: Option[NextToken]
    def maxResultsValue: Option[MaxResults]
    def filter: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.organizations.model.PolicyType
    ] = ZIO.succeed(filterValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListPoliciesRequest
  ) extends io.github.vigoo.zioaws.organizations.model.ListPoliciesRequest.ReadOnly {
    override def filterValue
        : io.github.vigoo.zioaws.organizations.model.PolicyType =
      io.github.vigoo.zioaws.organizations.model.PolicyType.wrap(impl.filter())
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListPoliciesRequest
  ): io.github.vigoo.zioaws.organizations.model.ListPoliciesRequest.ReadOnly =
    new Wrapper(impl)
}
