package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListParentsResponse(
    parents: Option[
      Iterable[io.github.vigoo.zioaws.organizations.model.Parent]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListParentsResponse = {
    import ListParentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListParentsResponse
      .builder()
      .optionallyWith(
        parents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parents)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListParentsResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListParentsResponse
      .wrap(buildAwsValue())
}
object ListParentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListParentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListParentsResponse =
      io.github.vigoo.zioaws.organizations.model.ListParentsResponse(
        parentsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def parentsValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.Parent.ReadOnly]
    ]
    def nextTokenValue: Option[NextToken]
    def parents: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.Parent.ReadOnly
    ]] = AwsError.unwrapOptionField("parents", parentsValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListParentsResponse
  ) extends io.github.vigoo.zioaws.organizations.model.ListParentsResponse.ReadOnly {
    override def parentsValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.Parent.ReadOnly]
    ] = scala
      .Option(impl.parents())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.Parent.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListParentsResponse
  ): io.github.vigoo.zioaws.organizations.model.ListParentsResponse.ReadOnly =
    new Wrapper(impl)
}
