package io.github.vigoo.zioaws.organizations.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  MaxResults,
  NextToken,
  ChildId
}
import scala.jdk.CollectionConverters.*
final case class ListParentsRequest(
    childId: ChildId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListParentsRequest = {
    import ListParentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListParentsRequest
      .builder()
      .childId(childId: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListParentsRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListParentsRequest
      .wrap(buildAwsValue())
}
object ListParentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListParentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListParentsRequest =
      io.github.vigoo.zioaws.organizations.model.ListParentsRequest(
        childIdValue,
        nextTokenValue.map(value => value),
        maxResultsValue.map(value => value)
      )
    def childIdValue: ChildId
    def nextTokenValue: Option[NextToken]
    def maxResultsValue: Option[MaxResults]
    def childId: ZIO[Any, Nothing, ChildId] = ZIO.succeed(childIdValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListParentsRequest
  ) extends io.github.vigoo.zioaws.organizations.model.ListParentsRequest.ReadOnly {
    override def childIdValue: ChildId = impl.childId(): ChildId
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListParentsRequest
  ): io.github.vigoo.zioaws.organizations.model.ListParentsRequest.ReadOnly =
    new Wrapper(impl)
}
