package io.github.vigoo.zioaws.organizations.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  MaxResults,
  NextToken
}
import scala.jdk.CollectionConverters.*
final case class ListAwsServiceAccessForOrganizationRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationRequest = {
    import ListAwsServiceAccessForOrganizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListAwsServiceAccessForOrganizationRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListAwsServiceAccessForOrganizationRequest
      .wrap(buildAwsValue())
}
object ListAwsServiceAccessForOrganizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListAwsServiceAccessForOrganizationRequest =
      io.github.vigoo.zioaws.organizations.model
        .ListAwsServiceAccessForOrganizationRequest(
          nextTokenValue.map(value => value),
          maxResultsValue.map(value => value)
        )
    def nextTokenValue: Option[NextToken]
    def maxResultsValue: Option[MaxResults]
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationRequest
  ) extends io.github.vigoo.zioaws.organizations.model.ListAwsServiceAccessForOrganizationRequest.ReadOnly {
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationRequest
  ): io.github.vigoo.zioaws.organizations.model.ListAwsServiceAccessForOrganizationRequest.ReadOnly =
    new Wrapper(impl)
}
