package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
sealed trait HandshakeState {
  def unwrap: software.amazon.awssdk.services.organizations.model.HandshakeState
}
object HandshakeState {
  def wrap(
      value: software.amazon.awssdk.services.organizations.model.HandshakeState
  ): io.github.vigoo.zioaws.organizations.model.HandshakeState = value match {
    case software.amazon.awssdk.services.organizations.model.HandshakeState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.organizations.model.HandshakeState.REQUESTED =>
      val r = REQUESTED
      r
    case software.amazon.awssdk.services.organizations.model.HandshakeState.OPEN =>
      val r = OPEN
      r
    case software.amazon.awssdk.services.organizations.model.HandshakeState.CANCELED =>
      val r = CANCELED
      r
    case software.amazon.awssdk.services.organizations.model.HandshakeState.ACCEPTED =>
      val r = ACCEPTED
      r
    case software.amazon.awssdk.services.organizations.model.HandshakeState.DECLINED =>
      val r = DECLINED
      r
    case software.amazon.awssdk.services.organizations.model.HandshakeState.EXPIRED =>
      val r = EXPIRED
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.organizations.model.HandshakeState {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakeState =
      software.amazon.awssdk.services.organizations.model.HandshakeState.UNKNOWN_TO_SDK_VERSION
  }
  case object REQUESTED
      extends io.github.vigoo.zioaws.organizations.model.HandshakeState {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakeState =
      software.amazon.awssdk.services.organizations.model.HandshakeState.REQUESTED
  }
  case object OPEN
      extends io.github.vigoo.zioaws.organizations.model.HandshakeState {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakeState =
      software.amazon.awssdk.services.organizations.model.HandshakeState.OPEN
  }
  case object CANCELED
      extends io.github.vigoo.zioaws.organizations.model.HandshakeState {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakeState =
      software.amazon.awssdk.services.organizations.model.HandshakeState.CANCELED
  }
  case object ACCEPTED
      extends io.github.vigoo.zioaws.organizations.model.HandshakeState {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakeState =
      software.amazon.awssdk.services.organizations.model.HandshakeState.ACCEPTED
  }
  case object DECLINED
      extends io.github.vigoo.zioaws.organizations.model.HandshakeState {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakeState =
      software.amazon.awssdk.services.organizations.model.HandshakeState.DECLINED
  }
  case object EXPIRED
      extends io.github.vigoo.zioaws.organizations.model.HandshakeState {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakeState =
      software.amazon.awssdk.services.organizations.model.HandshakeState.EXPIRED
  }
}
