package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
sealed trait HandshakeResourceType {
  def unwrap: software.amazon.awssdk.services.organizations.model.HandshakeResourceType
}
object HandshakeResourceType {
  def wrap(
      value: software.amazon.awssdk.services.organizations.model.HandshakeResourceType
  ): io.github.vigoo.zioaws.organizations.model.HandshakeResourceType =
    value match {
      case software.amazon.awssdk.services.organizations.model.HandshakeResourceType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.organizations.model.HandshakeResourceType.ACCOUNT =>
        val r = ACCOUNT
        r
      case software.amazon.awssdk.services.organizations.model.HandshakeResourceType.ORGANIZATION =>
        val r = ORGANIZATION
        r
      case software.amazon.awssdk.services.organizations.model.HandshakeResourceType.ORGANIZATION_FEATURE_SET =>
        val r = ORGANIZATION_FEATURE_SET
        r
      case software.amazon.awssdk.services.organizations.model.HandshakeResourceType.EMAIL =>
        val r = EMAIL
        r
      case software.amazon.awssdk.services.organizations.model.HandshakeResourceType.MASTER_EMAIL =>
        val r = MASTER_EMAIL
        r
      case software.amazon.awssdk.services.organizations.model.HandshakeResourceType.MASTER_NAME =>
        val r = MASTER_NAME
        r
      case software.amazon.awssdk.services.organizations.model.HandshakeResourceType.NOTES =>
        val r = NOTES
        r
      case software.amazon.awssdk.services.organizations.model.HandshakeResourceType.PARENT_HANDSHAKE =>
        val r = PARENT_HANDSHAKE
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.organizations.model.HandshakeResourceType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakeResourceType =
      software.amazon.awssdk.services.organizations.model.HandshakeResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCOUNT
      extends io.github.vigoo.zioaws.organizations.model.HandshakeResourceType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakeResourceType =
      software.amazon.awssdk.services.organizations.model.HandshakeResourceType.ACCOUNT
  }
  case object ORGANIZATION
      extends io.github.vigoo.zioaws.organizations.model.HandshakeResourceType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakeResourceType =
      software.amazon.awssdk.services.organizations.model.HandshakeResourceType.ORGANIZATION
  }
  case object ORGANIZATION_FEATURE_SET
      extends io.github.vigoo.zioaws.organizations.model.HandshakeResourceType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakeResourceType =
      software.amazon.awssdk.services.organizations.model.HandshakeResourceType.ORGANIZATION_FEATURE_SET
  }
  case object EMAIL
      extends io.github.vigoo.zioaws.organizations.model.HandshakeResourceType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakeResourceType =
      software.amazon.awssdk.services.organizations.model.HandshakeResourceType.EMAIL
  }
  case object MASTER_EMAIL
      extends io.github.vigoo.zioaws.organizations.model.HandshakeResourceType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakeResourceType =
      software.amazon.awssdk.services.organizations.model.HandshakeResourceType.MASTER_EMAIL
  }
  case object MASTER_NAME
      extends io.github.vigoo.zioaws.organizations.model.HandshakeResourceType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakeResourceType =
      software.amazon.awssdk.services.organizations.model.HandshakeResourceType.MASTER_NAME
  }
  case object NOTES
      extends io.github.vigoo.zioaws.organizations.model.HandshakeResourceType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakeResourceType =
      software.amazon.awssdk.services.organizations.model.HandshakeResourceType.NOTES
  }
  case object PARENT_HANDSHAKE
      extends io.github.vigoo.zioaws.organizations.model.HandshakeResourceType {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.HandshakeResourceType =
      software.amazon.awssdk.services.organizations.model.HandshakeResourceType.PARENT_HANDSHAKE
  }
}
