package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  Timestamp,
  HandshakeArn,
  HandshakeId
}
import scala.jdk.CollectionConverters.*
final case class Handshake(
    id: Option[HandshakeId] = None,
    arn: Option[HandshakeArn] = None,
    parties: Option[
      Iterable[io.github.vigoo.zioaws.organizations.model.HandshakeParty]
    ] = None,
    state: Option[io.github.vigoo.zioaws.organizations.model.HandshakeState] =
      None,
    requestedTimestamp: Option[Timestamp] = None,
    expirationTimestamp: Option[Timestamp] = None,
    action: Option[io.github.vigoo.zioaws.organizations.model.ActionType] =
      None,
    resources: Option[
      Iterable[io.github.vigoo.zioaws.organizations.model.HandshakeResource]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.Handshake = {
    import Handshake.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.Handshake
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        parties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parties)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(requestedTimestamp.map(value => value: Instant))(
        _.requestedTimestamp
      )
      .optionallyWith(expirationTimestamp.map(value => value: Instant))(
        _.expirationTimestamp
      )
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resources)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.Handshake.wrap(buildAwsValue())
}
object Handshake {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.Handshake
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.organizations.model.Handshake =
      io.github.vigoo.zioaws.organizations.model.Handshake(
        idValue.map(value => value),
        arnValue.map(value => value),
        partiesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        stateValue.map(value => value),
        requestedTimestampValue.map(value => value),
        expirationTimestampValue.map(value => value),
        actionValue.map(value => value),
        resourcesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def idValue: Option[HandshakeId]
    def arnValue: Option[HandshakeArn]
    def partiesValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.HandshakeParty.ReadOnly]
    ]
    def stateValue
        : Option[io.github.vigoo.zioaws.organizations.model.HandshakeState]
    def requestedTimestampValue: Option[Timestamp]
    def expirationTimestampValue: Option[Timestamp]
    def actionValue
        : Option[io.github.vigoo.zioaws.organizations.model.ActionType]
    def resourcesValue: Option[List[
      io.github.vigoo.zioaws.organizations.model.HandshakeResource.ReadOnly
    ]]
    def id: ZIO[Any, AwsError, HandshakeId] =
      AwsError.unwrapOptionField("id", idValue)
    def arn: ZIO[Any, AwsError, HandshakeArn] =
      AwsError.unwrapOptionField("arn", arnValue)
    def parties: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.HandshakeParty.ReadOnly
    ]] = AwsError.unwrapOptionField("parties", partiesValue)
    def state: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.HandshakeState
    ] = AwsError.unwrapOptionField("state", stateValue)
    def requestedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("requestedTimestamp", requestedTimestampValue)
    def expirationTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("expirationTimestamp", expirationTimestampValue)
    def action: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.ActionType
    ] = AwsError.unwrapOptionField("action", actionValue)
    def resources: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.HandshakeResource.ReadOnly
    ]] = AwsError.unwrapOptionField("resources", resourcesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.Handshake
  ) extends io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly {
    override def idValue: Option[HandshakeId] =
      scala.Option(impl.id()).map(value => value: HandshakeId)
    override def arnValue: Option[HandshakeArn] =
      scala.Option(impl.arn()).map(value => value: HandshakeArn)
    override def partiesValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.HandshakeParty.ReadOnly]
    ] = scala
      .Option(impl.parties())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.HandshakeParty.wrap(item)
        }.toList
      )
    override def stateValue
        : Option[io.github.vigoo.zioaws.organizations.model.HandshakeState] =
      scala
        .Option(impl.state())
        .map(value =>
          io.github.vigoo.zioaws.organizations.model.HandshakeState.wrap(value)
        )
    override def requestedTimestampValue: Option[Timestamp] =
      scala.Option(impl.requestedTimestamp()).map(value => value: Timestamp)
    override def expirationTimestampValue: Option[Timestamp] =
      scala.Option(impl.expirationTimestamp()).map(value => value: Timestamp)
    override def actionValue
        : Option[io.github.vigoo.zioaws.organizations.model.ActionType] = scala
      .Option(impl.action())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.ActionType.wrap(value)
      )
    override def resourcesValue: Option[List[
      io.github.vigoo.zioaws.organizations.model.HandshakeResource.ReadOnly
    ]] = scala
      .Option(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.HandshakeResource
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.Handshake
  ): io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly =
    new Wrapper(impl)
}
