package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.PolicyId
import scala.jdk.CollectionConverters.*
final case class DescribePolicyRequest(policyId: PolicyId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.DescribePolicyRequest = {
    import DescribePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribePolicyRequest
      .builder()
      .policyId(policyId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.DescribePolicyRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.DescribePolicyRequest
      .wrap(buildAwsValue())
}
object DescribePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.DescribePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.DescribePolicyRequest =
      io.github.vigoo.zioaws.organizations.model
        .DescribePolicyRequest(policyIdValue)
    def policyIdValue: PolicyId
    def policyId: ZIO[Any, Nothing, PolicyId] = ZIO.succeed(policyIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.DescribePolicyRequest
  ) extends io.github.vigoo.zioaws.organizations.model.DescribePolicyRequest.ReadOnly {
    override def policyIdValue: PolicyId = impl.policyId(): PolicyId
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.DescribePolicyRequest
  ): io.github.vigoo.zioaws.organizations.model.DescribePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
