package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.OrganizationalUnitId
import scala.jdk.CollectionConverters.*
final case class DescribeOrganizationalUnitRequest(
    organizationalUnitId: OrganizationalUnitId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitRequest = {
    import DescribeOrganizationalUnitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitRequest
      .builder()
      .organizationalUnitId(organizationalUnitId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.DescribeOrganizationalUnitRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.DescribeOrganizationalUnitRequest
      .wrap(buildAwsValue())
}
object DescribeOrganizationalUnitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.DescribeOrganizationalUnitRequest =
      io.github.vigoo.zioaws.organizations.model
        .DescribeOrganizationalUnitRequest(organizationalUnitIdValue)
    def organizationalUnitIdValue: OrganizationalUnitId
    def organizationalUnitId: ZIO[Any, Nothing, OrganizationalUnitId] =
      ZIO.succeed(organizationalUnitIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitRequest
  ) extends io.github.vigoo.zioaws.organizations.model.DescribeOrganizationalUnitRequest.ReadOnly {
    override def organizationalUnitIdValue: OrganizationalUnitId =
      impl.organizationalUnitId(): OrganizationalUnitId
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitRequest
  ): io.github.vigoo.zioaws.organizations.model.DescribeOrganizationalUnitRequest.ReadOnly =
    new Wrapper(impl)
}
