package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.HandshakeId
import scala.jdk.CollectionConverters.*
final case class DescribeHandshakeRequest(handshakeId: HandshakeId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.DescribeHandshakeRequest = {
    import DescribeHandshakeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribeHandshakeRequest
      .builder()
      .handshakeId(handshakeId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.DescribeHandshakeRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.DescribeHandshakeRequest
      .wrap(buildAwsValue())
}
object DescribeHandshakeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.DescribeHandshakeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.DescribeHandshakeRequest =
      io.github.vigoo.zioaws.organizations.model
        .DescribeHandshakeRequest(handshakeIdValue)
    def handshakeIdValue: HandshakeId
    def handshakeId: ZIO[Any, Nothing, HandshakeId] =
      ZIO.succeed(handshakeIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.DescribeHandshakeRequest
  ) extends io.github.vigoo.zioaws.organizations.model.DescribeHandshakeRequest.ReadOnly {
    override def handshakeIdValue: HandshakeId = impl.handshakeId(): HandshakeId
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.DescribeHandshakeRequest
  ): io.github.vigoo.zioaws.organizations.model.DescribeHandshakeRequest.ReadOnly =
    new Wrapper(impl)
}
