package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeEffectivePolicyResponse(
    effectivePolicy: Option[
      io.github.vigoo.zioaws.organizations.model.EffectivePolicy
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyResponse = {
    import DescribeEffectivePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyResponse
      .builder()
      .optionallyWith(effectivePolicy.map(value => value.buildAwsValue()))(
        _.effectivePolicy
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyResponse
      .wrap(buildAwsValue())
}
object DescribeEffectivePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyResponse =
      io.github.vigoo.zioaws.organizations.model
        .DescribeEffectivePolicyResponse(
          effectivePolicyValue.map(value => value.editable)
        )
    def effectivePolicyValue: Option[
      io.github.vigoo.zioaws.organizations.model.EffectivePolicy.ReadOnly
    ]
    def effectivePolicy: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.EffectivePolicy.ReadOnly
    ] = AwsError.unwrapOptionField("effectivePolicy", effectivePolicyValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyResponse
  ) extends io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyResponse.ReadOnly {
    override def effectivePolicyValue: Option[
      io.github.vigoo.zioaws.organizations.model.EffectivePolicy.ReadOnly
    ] = scala
      .Option(impl.effectivePolicy())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.EffectivePolicy.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyResponse
  ): io.github.vigoo.zioaws.organizations.model.DescribeEffectivePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
