package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.CreateAccountRequestId
import scala.jdk.CollectionConverters.*
final case class DescribeCreateAccountStatusRequest(
    createAccountRequestId: CreateAccountRequestId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusRequest = {
    import DescribeCreateAccountStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusRequest
      .builder()
      .createAccountRequestId(createAccountRequestId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusRequest
      .wrap(buildAwsValue())
}
object DescribeCreateAccountStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusRequest =
      io.github.vigoo.zioaws.organizations.model
        .DescribeCreateAccountStatusRequest(createAccountRequestIdValue)
    def createAccountRequestIdValue: CreateAccountRequestId
    def createAccountRequestId: ZIO[Any, Nothing, CreateAccountRequestId] =
      ZIO.succeed(createAccountRequestIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusRequest
  ) extends io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusRequest.ReadOnly {
    override def createAccountRequestIdValue: CreateAccountRequestId =
      impl.createAccountRequestId(): CreateAccountRequestId
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusRequest
  ): io.github.vigoo.zioaws.organizations.model.DescribeCreateAccountStatusRequest.ReadOnly =
    new Wrapper(impl)
}
