package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeAccountResponse(
    account: Option[io.github.vigoo.zioaws.organizations.model.Account] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.DescribeAccountResponse = {
    import DescribeAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribeAccountResponse
      .builder()
      .optionallyWith(account.map(value => value.buildAwsValue()))(_.account)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.DescribeAccountResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.DescribeAccountResponse
      .wrap(buildAwsValue())
}
object DescribeAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.DescribeAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.DescribeAccountResponse =
      io.github.vigoo.zioaws.organizations.model
        .DescribeAccountResponse(accountValue.map(value => value.editable))
    def accountValue
        : Option[io.github.vigoo.zioaws.organizations.model.Account.ReadOnly]
    def account: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.Account.ReadOnly
    ] = AwsError.unwrapOptionField("account", accountValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.DescribeAccountResponse
  ) extends io.github.vigoo.zioaws.organizations.model.DescribeAccountResponse.ReadOnly {
    override def accountValue
        : Option[io.github.vigoo.zioaws.organizations.model.Account.ReadOnly] =
      scala
        .Option(impl.account())
        .map(value =>
          io.github.vigoo.zioaws.organizations.model.Account.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.DescribeAccountResponse
  ): io.github.vigoo.zioaws.organizations.model.DescribeAccountResponse.ReadOnly =
    new Wrapper(impl)
}
