package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.{
  ServicePrincipal,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class DeregisterDelegatedAdministratorRequest(
    accountId: AccountId,
    servicePrincipal: ServicePrincipal
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.DeregisterDelegatedAdministratorRequest = {
    import DeregisterDelegatedAdministratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DeregisterDelegatedAdministratorRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .servicePrincipal(servicePrincipal: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.DeregisterDelegatedAdministratorRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.DeregisterDelegatedAdministratorRequest
      .wrap(buildAwsValue())
}
object DeregisterDelegatedAdministratorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.DeregisterDelegatedAdministratorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.DeregisterDelegatedAdministratorRequest =
      io.github.vigoo.zioaws.organizations.model
        .DeregisterDelegatedAdministratorRequest(
          accountIdValue,
          servicePrincipalValue
        )
    def accountIdValue: AccountId
    def servicePrincipalValue: ServicePrincipal
    def accountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountIdValue)
    def servicePrincipal: ZIO[Any, Nothing, ServicePrincipal] =
      ZIO.succeed(servicePrincipalValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.DeregisterDelegatedAdministratorRequest
  ) extends io.github.vigoo.zioaws.organizations.model.DeregisterDelegatedAdministratorRequest.ReadOnly {
    override def accountIdValue: AccountId = impl.accountId(): AccountId
    override def servicePrincipalValue: ServicePrincipal =
      impl.servicePrincipal(): ServicePrincipal
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.DeregisterDelegatedAdministratorRequest
  ): io.github.vigoo.zioaws.organizations.model.DeregisterDelegatedAdministratorRequest.ReadOnly =
    new Wrapper(impl)
}
