package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.PolicyId
import scala.jdk.CollectionConverters.*
final case class DeletePolicyRequest(policyId: PolicyId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.DeletePolicyRequest = {
    import DeletePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DeletePolicyRequest
      .builder()
      .policyId(policyId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.DeletePolicyRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.DeletePolicyRequest
      .wrap(buildAwsValue())
}
object DeletePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.DeletePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.DeletePolicyRequest =
      io.github.vigoo.zioaws.organizations.model
        .DeletePolicyRequest(policyIdValue)
    def policyIdValue: PolicyId
    def policyId: ZIO[Any, Nothing, PolicyId] = ZIO.succeed(policyIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.DeletePolicyRequest
  ) extends io.github.vigoo.zioaws.organizations.model.DeletePolicyRequest.ReadOnly {
    override def policyIdValue: PolicyId = impl.policyId(): PolicyId
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.DeletePolicyRequest
  ): io.github.vigoo.zioaws.organizations.model.DeletePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
