package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  Timestamp,
  ServicePrincipal
}
import scala.jdk.CollectionConverters.*
final case class DelegatedService(
    servicePrincipal: Option[ServicePrincipal] = None,
    delegationEnabledDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.DelegatedService = {
    import DelegatedService.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DelegatedService
      .builder()
      .optionallyWith(servicePrincipal.map(value => value: java.lang.String))(
        _.servicePrincipal
      )
      .optionallyWith(delegationEnabledDate.map(value => value: Instant))(
        _.delegationEnabledDate
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.DelegatedService.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.DelegatedService
      .wrap(buildAwsValue())
}
object DelegatedService {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.DelegatedService
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.organizations.model.DelegatedService =
      io.github.vigoo.zioaws.organizations.model.DelegatedService(
        servicePrincipalValue.map(value => value),
        delegationEnabledDateValue.map(value => value)
      )
    def servicePrincipalValue: Option[ServicePrincipal]
    def delegationEnabledDateValue: Option[Timestamp]
    def servicePrincipal: ZIO[Any, AwsError, ServicePrincipal] =
      AwsError.unwrapOptionField("servicePrincipal", servicePrincipalValue)
    def delegationEnabledDate: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("delegationEnabledDate", delegationEnabledDateValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.DelegatedService
  ) extends io.github.vigoo.zioaws.organizations.model.DelegatedService.ReadOnly {
    override def servicePrincipalValue: Option[ServicePrincipal] = scala
      .Option(impl.servicePrincipal())
      .map(value => value: ServicePrincipal)
    override def delegationEnabledDateValue: Option[Timestamp] =
      scala.Option(impl.delegationEnabledDate()).map(value => value: Timestamp)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.DelegatedService
  ): io.github.vigoo.zioaws.organizations.model.DelegatedService.ReadOnly =
    new Wrapper(impl)
}
