package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeclineHandshakeResponse(
    handshake: Option[io.github.vigoo.zioaws.organizations.model.Handshake] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.DeclineHandshakeResponse = {
    import DeclineHandshakeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DeclineHandshakeResponse
      .builder()
      .optionallyWith(handshake.map(value => value.buildAwsValue()))(
        _.handshake
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.DeclineHandshakeResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.DeclineHandshakeResponse
      .wrap(buildAwsValue())
}
object DeclineHandshakeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.DeclineHandshakeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.DeclineHandshakeResponse =
      io.github.vigoo.zioaws.organizations.model
        .DeclineHandshakeResponse(handshakeValue.map(value => value.editable))
    def handshakeValue
        : Option[io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly]
    def handshake: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly
    ] = AwsError.unwrapOptionField("handshake", handshakeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.DeclineHandshakeResponse
  ) extends io.github.vigoo.zioaws.organizations.model.DeclineHandshakeResponse.ReadOnly {
    override def handshakeValue: Option[
      io.github.vigoo.zioaws.organizations.model.Handshake.ReadOnly
    ] = scala
      .Option(impl.handshake())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.Handshake.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.DeclineHandshakeResponse
  ): io.github.vigoo.zioaws.organizations.model.DeclineHandshakeResponse.ReadOnly =
    new Wrapper(impl)
}
