package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreatePolicyResponse(
    policy: Option[io.github.vigoo.zioaws.organizations.model.Policy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.CreatePolicyResponse = {
    import CreatePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CreatePolicyResponse
      .builder()
      .optionallyWith(policy.map(value => value.buildAwsValue()))(_.policy)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.CreatePolicyResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.CreatePolicyResponse
      .wrap(buildAwsValue())
}
object CreatePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.CreatePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.CreatePolicyResponse =
      io.github.vigoo.zioaws.organizations.model
        .CreatePolicyResponse(policyValue.map(value => value.editable))
    def policyValue
        : Option[io.github.vigoo.zioaws.organizations.model.Policy.ReadOnly]
    def policy: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.Policy.ReadOnly
    ] = AwsError.unwrapOptionField("policy", policyValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.CreatePolicyResponse
  ) extends io.github.vigoo.zioaws.organizations.model.CreatePolicyResponse.ReadOnly {
    override def policyValue
        : Option[io.github.vigoo.zioaws.organizations.model.Policy.ReadOnly] =
      scala
        .Option(impl.policy())
        .map(value =>
          io.github.vigoo.zioaws.organizations.model.Policy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.CreatePolicyResponse
  ): io.github.vigoo.zioaws.organizations.model.CreatePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
