package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  PolicyName,
  PolicyDescription,
  PolicyContent
}
import scala.jdk.CollectionConverters.*
final case class CreatePolicyRequest(
    content: PolicyContent,
    description: PolicyDescription,
    name: PolicyName,
    `type`: io.github.vigoo.zioaws.organizations.model.PolicyType,
    tags: Option[Iterable[io.github.vigoo.zioaws.organizations.model.Tag]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.CreatePolicyRequest = {
    import CreatePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CreatePolicyRequest
      .builder()
      .content(content: java.lang.String)
      .description(description: java.lang.String)
      .name(name: java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.CreatePolicyRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.CreatePolicyRequest
      .wrap(buildAwsValue())
}
object CreatePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.CreatePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.CreatePolicyRequest =
      io.github.vigoo.zioaws.organizations.model.CreatePolicyRequest(
        contentValue,
        descriptionValue,
        nameValue,
        typeValue,
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def contentValue: PolicyContent
    def descriptionValue: PolicyDescription
    def nameValue: PolicyName
    def typeValue: io.github.vigoo.zioaws.organizations.model.PolicyType
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly]]
    def content: ZIO[Any, Nothing, PolicyContent] = ZIO.succeed(contentValue)
    def description: ZIO[Any, Nothing, PolicyDescription] =
      ZIO.succeed(descriptionValue)
    def name: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(nameValue)
    def `type`: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.organizations.model.PolicyType
    ] = ZIO.succeed(typeValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.CreatePolicyRequest
  ) extends io.github.vigoo.zioaws.organizations.model.CreatePolicyRequest.ReadOnly {
    override def contentValue: PolicyContent = impl.content(): PolicyContent
    override def descriptionValue: PolicyDescription =
      impl.description(): PolicyDescription
    override def nameValue: PolicyName = impl.name(): PolicyName
    override def typeValue
        : io.github.vigoo.zioaws.organizations.model.PolicyType =
      io.github.vigoo.zioaws.organizations.model.PolicyType.wrap(impl.`type`())
    override def tagsValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly]
    ] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.CreatePolicyRequest
  ): io.github.vigoo.zioaws.organizations.model.CreatePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
