package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateOrganizationalUnitResponse(
    organizationalUnit: Option[
      io.github.vigoo.zioaws.organizations.model.OrganizationalUnit
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitResponse = {
    import CreateOrganizationalUnitResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitResponse
      .builder()
      .optionallyWith(organizationalUnit.map(value => value.buildAwsValue()))(
        _.organizationalUnit
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitResponse
      .wrap(buildAwsValue())
}
object CreateOrganizationalUnitResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitResponse =
      io.github.vigoo.zioaws.organizations.model
        .CreateOrganizationalUnitResponse(
          organizationalUnitValue.map(value => value.editable)
        )
    def organizationalUnitValue: Option[
      io.github.vigoo.zioaws.organizations.model.OrganizationalUnit.ReadOnly
    ]
    def organizationalUnit: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.OrganizationalUnit.ReadOnly
    ] =
      AwsError.unwrapOptionField("organizationalUnit", organizationalUnitValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitResponse
  ) extends io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitResponse.ReadOnly {
    override def organizationalUnitValue: Option[
      io.github.vigoo.zioaws.organizations.model.OrganizationalUnit.ReadOnly
    ] = scala
      .Option(impl.organizationalUnit())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.OrganizationalUnit
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitResponse
  ): io.github.vigoo.zioaws.organizations.model.CreateOrganizationalUnitResponse.ReadOnly =
    new Wrapper(impl)
}
