package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateOrganizationRequest(
    featureSet: Option[
      io.github.vigoo.zioaws.organizations.model.OrganizationFeatureSet
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.CreateOrganizationRequest = {
    import CreateOrganizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CreateOrganizationRequest
      .builder()
      .optionallyWith(featureSet.map(value => value.unwrap))(_.featureSet)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.CreateOrganizationRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.CreateOrganizationRequest
      .wrap(buildAwsValue())
}
object CreateOrganizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.CreateOrganizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.CreateOrganizationRequest =
      io.github.vigoo.zioaws.organizations.model
        .CreateOrganizationRequest(featureSetValue.map(value => value))
    def featureSetValue: Option[
      io.github.vigoo.zioaws.organizations.model.OrganizationFeatureSet
    ]
    def featureSet: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.OrganizationFeatureSet
    ] = AwsError.unwrapOptionField("featureSet", featureSetValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.CreateOrganizationRequest
  ) extends io.github.vigoo.zioaws.organizations.model.CreateOrganizationRequest.ReadOnly {
    override def featureSetValue: Option[
      io.github.vigoo.zioaws.organizations.model.OrganizationFeatureSet
    ] = scala
      .Option(impl.featureSet())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.OrganizationFeatureSet
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.CreateOrganizationRequest
  ): io.github.vigoo.zioaws.organizations.model.CreateOrganizationRequest.ReadOnly =
    new Wrapper(impl)
}
