package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  RoleName,
  AccountName,
  Email
}
import scala.jdk.CollectionConverters.*
final case class CreateAccountRequest(
    email: Email,
    accountName: AccountName,
    roleName: Option[RoleName] = None,
    iamUserAccessToBilling: Option[
      io.github.vigoo.zioaws.organizations.model.IAMUserAccessToBilling
    ] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.organizations.model.Tag]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.CreateAccountRequest = {
    import CreateAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CreateAccountRequest
      .builder()
      .email(email: java.lang.String)
      .accountName(accountName: java.lang.String)
      .optionallyWith(roleName.map(value => value: java.lang.String))(
        _.roleName
      )
      .optionallyWith(iamUserAccessToBilling.map(value => value.unwrap))(
        _.iamUserAccessToBilling
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.CreateAccountRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.CreateAccountRequest
      .wrap(buildAwsValue())
}
object CreateAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.CreateAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.CreateAccountRequest =
      io.github.vigoo.zioaws.organizations.model.CreateAccountRequest(
        emailValue,
        accountNameValue,
        roleNameValue.map(value => value),
        iamUserAccessToBillingValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def emailValue: Email
    def accountNameValue: AccountName
    def roleNameValue: Option[RoleName]
    def iamUserAccessToBillingValue: Option[
      io.github.vigoo.zioaws.organizations.model.IAMUserAccessToBilling
    ]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly]]
    def email: ZIO[Any, Nothing, Email] = ZIO.succeed(emailValue)
    def accountName: ZIO[Any, Nothing, AccountName] =
      ZIO.succeed(accountNameValue)
    def roleName: ZIO[Any, AwsError, RoleName] =
      AwsError.unwrapOptionField("roleName", roleNameValue)
    def iamUserAccessToBilling: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.IAMUserAccessToBilling
    ] = AwsError.unwrapOptionField(
      "iamUserAccessToBilling",
      iamUserAccessToBillingValue
    )
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.CreateAccountRequest
  ) extends io.github.vigoo.zioaws.organizations.model.CreateAccountRequest.ReadOnly {
    override def emailValue: Email = impl.email(): Email
    override def accountNameValue: AccountName = impl.accountName(): AccountName
    override def roleNameValue: Option[RoleName] =
      scala.Option(impl.roleName()).map(value => value: RoleName)
    override def iamUserAccessToBillingValue: Option[
      io.github.vigoo.zioaws.organizations.model.IAMUserAccessToBilling
    ] = scala
      .Option(impl.iamUserAccessToBilling())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.IAMUserAccessToBilling
          .wrap(value)
      )
    override def tagsValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.Tag.ReadOnly]
    ] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.CreateAccountRequest
  ): io.github.vigoo.zioaws.organizations.model.CreateAccountRequest.ReadOnly =
    new Wrapper(impl)
}
