package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.HandshakeId
import scala.jdk.CollectionConverters.*
final case class CancelHandshakeRequest(handshakeId: HandshakeId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.CancelHandshakeRequest = {
    import CancelHandshakeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CancelHandshakeRequest
      .builder()
      .handshakeId(handshakeId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.CancelHandshakeRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.CancelHandshakeRequest
      .wrap(buildAwsValue())
}
object CancelHandshakeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.CancelHandshakeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.CancelHandshakeRequest =
      io.github.vigoo.zioaws.organizations.model
        .CancelHandshakeRequest(handshakeIdValue)
    def handshakeIdValue: HandshakeId
    def handshakeId: ZIO[Any, Nothing, HandshakeId] =
      ZIO.succeed(handshakeIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.CancelHandshakeRequest
  ) extends io.github.vigoo.zioaws.organizations.model.CancelHandshakeRequest.ReadOnly {
    override def handshakeIdValue: HandshakeId = impl.handshakeId(): HandshakeId
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.CancelHandshakeRequest
  ): io.github.vigoo.zioaws.organizations.model.CancelHandshakeRequest.ReadOnly =
    new Wrapper(impl)
}
