package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  AccountId,
  Timestamp,
  AccountArn,
  Email,
  AccountName
}
import scala.jdk.CollectionConverters.*
final case class Account(
    id: Option[AccountId] = None,
    arn: Option[AccountArn] = None,
    email: Option[Email] = None,
    name: Option[AccountName] = None,
    status: Option[io.github.vigoo.zioaws.organizations.model.AccountStatus] =
      None,
    joinedMethod: Option[
      io.github.vigoo.zioaws.organizations.model.AccountJoinedMethod
    ] = None,
    joinedTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.Account = {
    import Account.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.Account
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(email.map(value => value: java.lang.String))(_.email)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(joinedMethod.map(value => value.unwrap))(_.joinedMethod)
      .optionallyWith(joinedTimestamp.map(value => value: Instant))(
        _.joinedTimestamp
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.organizations.model.Account.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.Account.wrap(buildAwsValue())
}
object Account {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.Account
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.organizations.model.Account =
      io.github.vigoo.zioaws.organizations.model.Account(
        idValue.map(value => value),
        arnValue.map(value => value),
        emailValue.map(value => value),
        nameValue.map(value => value),
        statusValue.map(value => value),
        joinedMethodValue.map(value => value),
        joinedTimestampValue.map(value => value)
      )
    def idValue: Option[AccountId]
    def arnValue: Option[AccountArn]
    def emailValue: Option[Email]
    def nameValue: Option[AccountName]
    def statusValue
        : Option[io.github.vigoo.zioaws.organizations.model.AccountStatus]
    def joinedMethodValue
        : Option[io.github.vigoo.zioaws.organizations.model.AccountJoinedMethod]
    def joinedTimestampValue: Option[Timestamp]
    def id: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("id", idValue)
    def arn: ZIO[Any, AwsError, AccountArn] =
      AwsError.unwrapOptionField("arn", arnValue)
    def email: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("email", emailValue)
    def name: ZIO[Any, AwsError, AccountName] =
      AwsError.unwrapOptionField("name", nameValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.AccountStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
    def joinedMethod: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.AccountJoinedMethod
    ] = AwsError.unwrapOptionField("joinedMethod", joinedMethodValue)
    def joinedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("joinedTimestamp", joinedTimestampValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.Account
  ) extends io.github.vigoo.zioaws.organizations.model.Account.ReadOnly {
    override def idValue: Option[AccountId] =
      scala.Option(impl.id()).map(value => value: AccountId)
    override def arnValue: Option[AccountArn] =
      scala.Option(impl.arn()).map(value => value: AccountArn)
    override def emailValue: Option[Email] =
      scala.Option(impl.email()).map(value => value: Email)
    override def nameValue: Option[AccountName] =
      scala.Option(impl.name()).map(value => value: AccountName)
    override def statusValue
        : Option[io.github.vigoo.zioaws.organizations.model.AccountStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          io.github.vigoo.zioaws.organizations.model.AccountStatus.wrap(value)
        )
    override def joinedMethodValue: Option[
      io.github.vigoo.zioaws.organizations.model.AccountJoinedMethod
    ] = scala
      .Option(impl.joinedMethod())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.AccountJoinedMethod
          .wrap(value)
      )
    override def joinedTimestampValue: Option[Timestamp] =
      scala.Option(impl.joinedTimestamp()).map(value => value: Timestamp)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.Account
  ): io.github.vigoo.zioaws.organizations.model.Account.ReadOnly = new Wrapper(
    impl
  )
}
