package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.HandshakeId
import scala.jdk.CollectionConverters.*
final case class AcceptHandshakeRequest(handshakeId: HandshakeId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.AcceptHandshakeRequest = {
    import AcceptHandshakeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.AcceptHandshakeRequest
      .builder()
      .handshakeId(handshakeId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.AcceptHandshakeRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.AcceptHandshakeRequest
      .wrap(buildAwsValue())
}
object AcceptHandshakeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.AcceptHandshakeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.AcceptHandshakeRequest =
      io.github.vigoo.zioaws.organizations.model
        .AcceptHandshakeRequest(handshakeIdValue)
    def handshakeIdValue: HandshakeId
    def handshakeId: ZIO[Any, Nothing, HandshakeId] =
      ZIO.succeed(handshakeIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.AcceptHandshakeRequest
  ) extends io.github.vigoo.zioaws.organizations.model.AcceptHandshakeRequest.ReadOnly {
    override def handshakeIdValue: HandshakeId = impl.handshakeId(): HandshakeId
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.AcceptHandshakeRequest
  ): io.github.vigoo.zioaws.organizations.model.AcceptHandshakeRequest.ReadOnly =
    new Wrapper(impl)
}
