package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListPoliciesResponse(
    policies: Option[
      Iterable[io.github.vigoo.zioaws.organizations.model.PolicySummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListPoliciesResponse = {
    import ListPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListPoliciesResponse
      .builder()
      .optionallyWith(
        policies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policies)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListPoliciesResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListPoliciesResponse
      .wrap(buildAwsValue())
}
object ListPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListPoliciesResponse =
      io.github.vigoo.zioaws.organizations.model.ListPoliciesResponse(
        policiesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def policiesValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly]
    ]
    def nextTokenValue: Option[NextToken]
    def policies: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly
    ]] = AwsError.unwrapOptionField("policies", policiesValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListPoliciesResponse
  ) extends io.github.vigoo.zioaws.organizations.model.ListPoliciesResponse.ReadOnly {
    override def policiesValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.PolicySummary.ReadOnly]
    ] = scala
      .Option(impl.policies())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.PolicySummary.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListPoliciesResponse
  ): io.github.vigoo.zioaws.organizations.model.ListPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
