package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListAccountsResponse(
    accounts: Option[
      Iterable[io.github.vigoo.zioaws.organizations.model.Account]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListAccountsResponse = {
    import ListAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListAccountsResponse
      .builder()
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accounts)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListAccountsResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListAccountsResponse
      .wrap(buildAwsValue())
}
object ListAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListAccountsResponse =
      io.github.vigoo.zioaws.organizations.model.ListAccountsResponse(
        accountsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def accountsValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.Account.ReadOnly]
    ]
    def nextTokenValue: Option[NextToken]
    def accounts: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.Account.ReadOnly
    ]] = AwsError.unwrapOptionField("accounts", accountsValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListAccountsResponse
  ) extends io.github.vigoo.zioaws.organizations.model.ListAccountsResponse.ReadOnly {
    override def accountsValue: Option[
      List[io.github.vigoo.zioaws.organizations.model.Account.ReadOnly]
    ] = scala
      .Option(impl.accounts())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.Account.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListAccountsResponse
  ): io.github.vigoo.zioaws.organizations.model.ListAccountsResponse.ReadOnly =
    new Wrapper(impl)
}
