package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.RootId
import scala.jdk.CollectionConverters.*
final case class DisablePolicyTypeRequest(
    rootId: RootId,
    policyType: io.github.vigoo.zioaws.organizations.model.PolicyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.DisablePolicyTypeRequest = {
    import DisablePolicyTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DisablePolicyTypeRequest
      .builder()
      .rootId(rootId: java.lang.String)
      .policyType(policyType.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeRequest
      .wrap(buildAwsValue())
}
object DisablePolicyTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.DisablePolicyTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeRequest =
      io.github.vigoo.zioaws.organizations.model
        .DisablePolicyTypeRequest(rootIdValue, policyTypeValue)
    def rootIdValue: RootId
    def policyTypeValue: io.github.vigoo.zioaws.organizations.model.PolicyType
    def rootId: ZIO[Any, Nothing, RootId] = ZIO.succeed(rootIdValue)
    def policyType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.organizations.model.PolicyType
    ] = ZIO.succeed(policyTypeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.DisablePolicyTypeRequest
  ) extends io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeRequest.ReadOnly {
    override def rootIdValue: RootId = impl.rootId(): RootId
    override def policyTypeValue
        : io.github.vigoo.zioaws.organizations.model.PolicyType =
      io.github.vigoo.zioaws.organizations.model.PolicyType
        .wrap(impl.policyType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.DisablePolicyTypeRequest
  ): io.github.vigoo.zioaws.organizations.model.DisablePolicyTypeRequest.ReadOnly =
    new Wrapper(impl)
}
