package io.github.vigoo.zioaws.organizations.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.{
  MaxResults,
  NextToken,
  ServicePrincipal
}
import scala.jdk.CollectionConverters.*
final case class ListDelegatedAdministratorsRequest(
    servicePrincipal: Option[ServicePrincipal] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsRequest = {
    import ListDelegatedAdministratorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsRequest
      .builder()
      .optionallyWith(servicePrincipal.map(value => value: java.lang.String))(
        _.servicePrincipal
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListDelegatedAdministratorsRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListDelegatedAdministratorsRequest
      .wrap(buildAwsValue())
}
object ListDelegatedAdministratorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListDelegatedAdministratorsRequest =
      io.github.vigoo.zioaws.organizations.model
        .ListDelegatedAdministratorsRequest(
          servicePrincipalValue.map(value => value),
          nextTokenValue.map(value => value),
          maxResultsValue.map(value => value)
        )
    def servicePrincipalValue: Option[ServicePrincipal]
    def nextTokenValue: Option[NextToken]
    def maxResultsValue: Option[MaxResults]
    def servicePrincipal: ZIO[Any, AwsError, ServicePrincipal] =
      AwsError.unwrapOptionField("servicePrincipal", servicePrincipalValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsRequest
  ) extends io.github.vigoo.zioaws.organizations.model.ListDelegatedAdministratorsRequest.ReadOnly {
    override def servicePrincipalValue: Option[ServicePrincipal] = scala
      .Option(impl.servicePrincipal())
      .map(value => value: ServicePrincipal)
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsRequest
  ): io.github.vigoo.zioaws.organizations.model.ListDelegatedAdministratorsRequest.ReadOnly =
    new Wrapper(impl)
}
