package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.organizations.model.primitives.HandshakeId
import scala.jdk.CollectionConverters.*
final case class DeclineHandshakeRequest(handshakeId: HandshakeId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.DeclineHandshakeRequest = {
    import DeclineHandshakeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DeclineHandshakeRequest
      .builder()
      .handshakeId(handshakeId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.DeclineHandshakeRequest.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.DeclineHandshakeRequest
      .wrap(buildAwsValue())
}
object DeclineHandshakeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.DeclineHandshakeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.DeclineHandshakeRequest =
      io.github.vigoo.zioaws.organizations.model
        .DeclineHandshakeRequest(handshakeIdValue)
    def handshakeIdValue: HandshakeId
    def handshakeId: ZIO[Any, Nothing, HandshakeId] =
      ZIO.succeed(handshakeIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.DeclineHandshakeRequest
  ) extends io.github.vigoo.zioaws.organizations.model.DeclineHandshakeRequest.ReadOnly {
    override def handshakeIdValue: HandshakeId = impl.handshakeId(): HandshakeId
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.DeclineHandshakeRequest
  ): io.github.vigoo.zioaws.organizations.model.DeclineHandshakeRequest.ReadOnly =
    new Wrapper(impl)
}
