package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
sealed trait AccountStatus {
  def unwrap: software.amazon.awssdk.services.organizations.model.AccountStatus
}
object AccountStatus {
  def wrap(
      value: software.amazon.awssdk.services.organizations.model.AccountStatus
  ): io.github.vigoo.zioaws.organizations.model.AccountStatus = value match {
    case software.amazon.awssdk.services.organizations.model.AccountStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.organizations.model.AccountStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.organizations.model.AccountStatus.SUSPENDED =>
      val r = SUSPENDED
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.organizations.model.AccountStatus {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.AccountStatus =
      software.amazon.awssdk.services.organizations.model.AccountStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE
      extends io.github.vigoo.zioaws.organizations.model.AccountStatus {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.AccountStatus =
      software.amazon.awssdk.services.organizations.model.AccountStatus.ACTIVE
  }
  case object SUSPENDED
      extends io.github.vigoo.zioaws.organizations.model.AccountStatus {
    override def unwrap
        : software.amazon.awssdk.services.organizations.model.AccountStatus =
      software.amazon.awssdk.services.organizations.model.AccountStatus.SUSPENDED
  }
}
