package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.organizations.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListTargetsForPolicyResponse(
    targets: Option[
      Iterable[io.github.vigoo.zioaws.organizations.model.PolicyTargetSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse = {
    import ListTargetsForPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse
      .builder()
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.ListTargetsForPolicyResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.ListTargetsForPolicyResponse
      .wrap(buildAwsValue())
}
object ListTargetsForPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.ListTargetsForPolicyResponse =
      io.github.vigoo.zioaws.organizations.model.ListTargetsForPolicyResponse(
        targetsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def targetsValue: Option[List[
      io.github.vigoo.zioaws.organizations.model.PolicyTargetSummary.ReadOnly
    ]]
    def nextTokenValue: Option[NextToken]
    def targets: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.organizations.model.PolicyTargetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("targets", targetsValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse
  ) extends io.github.vigoo.zioaws.organizations.model.ListTargetsForPolicyResponse.ReadOnly {
    override def targetsValue: Option[List[
      io.github.vigoo.zioaws.organizations.model.PolicyTargetSummary.ReadOnly
    ]] = scala
      .Option(impl.targets())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.organizations.model.PolicyTargetSummary
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse
  ): io.github.vigoo.zioaws.organizations.model.ListTargetsForPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
