package io.github.vigoo.zioaws.organizations.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateOrganizationResponse(
    organization: Option[
      io.github.vigoo.zioaws.organizations.model.Organization
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.organizations.model.CreateOrganizationResponse = {
    import CreateOrganizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CreateOrganizationResponse
      .builder()
      .optionallyWith(organization.map(value => value.buildAwsValue()))(
        _.organization
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.organizations.model.CreateOrganizationResponse.ReadOnly =
    io.github.vigoo.zioaws.organizations.model.CreateOrganizationResponse
      .wrap(buildAwsValue())
}
object CreateOrganizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.organizations.model.CreateOrganizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.organizations.model.CreateOrganizationResponse =
      io.github.vigoo.zioaws.organizations.model.CreateOrganizationResponse(
        organizationValue.map(value => value.editable)
      )
    def organizationValue: Option[
      io.github.vigoo.zioaws.organizations.model.Organization.ReadOnly
    ]
    def organization: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.organizations.model.Organization.ReadOnly
    ] = AwsError.unwrapOptionField("organization", organizationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.organizations.model.CreateOrganizationResponse
  ) extends io.github.vigoo.zioaws.organizations.model.CreateOrganizationResponse.ReadOnly {
    override def organizationValue: Option[
      io.github.vigoo.zioaws.organizations.model.Organization.ReadOnly
    ] = scala
      .Option(impl.organization())
      .map(value =>
        io.github.vigoo.zioaws.organizations.model.Organization.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.organizations.model.CreateOrganizationResponse
  ): io.github.vigoo.zioaws.organizations.model.CreateOrganizationResponse.ReadOnly =
    new Wrapper(impl)
}
