package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.core.*
import io.github.vigoo.zioaws.core.aspects.*
import io.github.vigoo.zioaws.core.config.AwsConfig
import io.github.vigoo.zioaws.core.httpclient.ServiceHttpCapabilities
import software.amazon.awssdk.core.client.config.{ ClientAsyncConfiguration, SdkAdvancedAsyncClientOption }
import software.amazon.awssdk.services.organizations.{ OrganizationsAsyncClient, OrganizationsAsyncClientBuilder }
import zio.{ Chunk, Has, IO, URLayer, ZIO, ZLayer, ZManaged }
import zio.stream.ZStream
import org.reactivestreams.Publisher
import scala.jdk.CollectionConverters.*
package object organizations {
  type Organizations = Has[Organizations.Service]
  object Organizations {
    trait Service extends AspectSupport[Service] {
      val api: OrganizationsAsyncClient
      def listParents(request: model.ListParentsRequest): ZStream[Any, AwsError, model.Parent.ReadOnly]
      def inviteAccountToOrganization(request: model.InviteAccountToOrganizationRequest): IO[AwsError, model.InviteAccountToOrganizationResponse.ReadOnly]
      def describeOrganization(): IO[AwsError, model.DescribeOrganizationResponse.ReadOnly]
      def describePolicy(request: model.DescribePolicyRequest): IO[AwsError, model.DescribePolicyResponse.ReadOnly]
      def createAccount(request: model.CreateAccountRequest): IO[AwsError, model.CreateAccountResponse.ReadOnly]
      def moveAccount(request: model.MoveAccountRequest): IO[AwsError, scala.Unit]
      def listAccounts(request: model.ListAccountsRequest): ZStream[Any, AwsError, model.Account.ReadOnly]
      def deleteOrganizationalUnit(request: model.DeleteOrganizationalUnitRequest): IO[AwsError, scala.Unit]
      def enableAllFeatures(request: model.EnableAllFeaturesRequest): IO[AwsError, model.EnableAllFeaturesResponse.ReadOnly]
      def cancelHandshake(request: model.CancelHandshakeRequest): IO[AwsError, model.CancelHandshakeResponse.ReadOnly]
      def listAccountsForParent(request: model.ListAccountsForParentRequest): ZStream[Any, AwsError, model.Account.ReadOnly]
      def enablePolicyType(request: model.EnablePolicyTypeRequest): IO[AwsError, model.EnablePolicyTypeResponse.ReadOnly]
      def disablePolicyType(request: model.DisablePolicyTypeRequest): IO[AwsError, model.DisablePolicyTypeResponse.ReadOnly]
      def describeOrganizationalUnit(request: model.DescribeOrganizationalUnitRequest): IO[AwsError, model.DescribeOrganizationalUnitResponse.ReadOnly]
      def listHandshakesForOrganization(request: model.ListHandshakesForOrganizationRequest): ZStream[Any, AwsError, model.Handshake.ReadOnly]
      def listTargetsForPolicy(request: model.ListTargetsForPolicyRequest): ZStream[Any, AwsError, model.PolicyTargetSummary.ReadOnly]
      def detachPolicy(request: model.DetachPolicyRequest): IO[AwsError, scala.Unit]
      def updatePolicy(request: model.UpdatePolicyRequest): IO[AwsError, model.UpdatePolicyResponse.ReadOnly]
      def leaveOrganization(): IO[AwsError, scala.Unit]
      def enableAWSServiceAccess(request: model.EnableAwsServiceAccessRequest): IO[AwsError, scala.Unit]
      def describeAccount(request: model.DescribeAccountRequest): IO[AwsError, model.DescribeAccountResponse.ReadOnly]
      def deleteOrganization(): IO[AwsError, scala.Unit]
      def createOrganizationalUnit(request: model.CreateOrganizationalUnitRequest): IO[AwsError, model.CreateOrganizationalUnitResponse.ReadOnly]
      def acceptHandshake(request: model.AcceptHandshakeRequest): IO[AwsError, model.AcceptHandshakeResponse.ReadOnly]
      def listPoliciesForTarget(request: model.ListPoliciesForTargetRequest): ZStream[Any, AwsError, model.PolicySummary.ReadOnly]
      def listOrganizationalUnitsForParent(request: model.ListOrganizationalUnitsForParentRequest): ZStream[Any, AwsError, model.OrganizationalUnit.ReadOnly]
      def updateOrganizationalUnit(request: model.UpdateOrganizationalUnitRequest): IO[AwsError, model.UpdateOrganizationalUnitResponse.ReadOnly]
      def listPolicies(request: model.ListPoliciesRequest): ZStream[Any, AwsError, model.PolicySummary.ReadOnly]
      def describeHandshake(request: model.DescribeHandshakeRequest): IO[AwsError, model.DescribeHandshakeResponse.ReadOnly]
      def describeCreateAccountStatus(request: model.DescribeCreateAccountStatusRequest): IO[AwsError, model.DescribeCreateAccountStatusResponse.ReadOnly]
      def listRoots(request: model.ListRootsRequest): ZStream[Any, AwsError, model.Root.ReadOnly]
      def listCreateAccountStatus(request: model.ListCreateAccountStatusRequest): ZStream[Any, AwsError, model.CreateAccountStatus.ReadOnly]
      def untagResource(request: model.UntagResourceRequest): IO[AwsError, scala.Unit]
      def removeAccountFromOrganization(request: model.RemoveAccountFromOrganizationRequest): IO[AwsError, scala.Unit]
      def listAWSServiceAccessForOrganization(request: model.ListAwsServiceAccessForOrganizationRequest): ZStream[Any, AwsError, model.EnabledServicePrincipal.ReadOnly]
      def deregisterDelegatedAdministrator(request: model.DeregisterDelegatedAdministratorRequest): IO[AwsError, scala.Unit]
      def declineHandshake(request: model.DeclineHandshakeRequest): IO[AwsError, model.DeclineHandshakeResponse.ReadOnly]
      def attachPolicy(request: model.AttachPolicyRequest): IO[AwsError, scala.Unit]
      def listTagsForResource(request: model.ListTagsForResourceRequest): ZStream[Any, AwsError, model.Tag.ReadOnly]
      def listDelegatedServicesForAccount(request: model.ListDelegatedServicesForAccountRequest): ZStream[Any, AwsError, model.DelegatedService.ReadOnly]
      def registerDelegatedAdministrator(request: model.RegisterDelegatedAdministratorRequest): IO[AwsError, scala.Unit]
      def describeEffectivePolicy(request: model.DescribeEffectivePolicyRequest): IO[AwsError, model.DescribeEffectivePolicyResponse.ReadOnly]
      def createPolicy(request: model.CreatePolicyRequest): IO[AwsError, model.CreatePolicyResponse.ReadOnly]
      def tagResource(request: model.TagResourceRequest): IO[AwsError, scala.Unit]
      def listChildren(request: model.ListChildrenRequest): ZStream[Any, AwsError, model.Child.ReadOnly]
      def deletePolicy(request: model.DeletePolicyRequest): IO[AwsError, scala.Unit]
      def listHandshakesForAccount(request: model.ListHandshakesForAccountRequest): ZStream[Any, AwsError, model.Handshake.ReadOnly]
      def createGovCloudAccount(request: model.CreateGovCloudAccountRequest): IO[AwsError, model.CreateGovCloudAccountResponse.ReadOnly]
      def disableAWSServiceAccess(request: model.DisableAwsServiceAccessRequest): IO[AwsError, scala.Unit]
      def listDelegatedAdministrators(request: model.ListDelegatedAdministratorsRequest): ZStream[Any, AwsError, model.DelegatedAdministrator.ReadOnly]
      def createOrganization(request: model.CreateOrganizationRequest): IO[AwsError, model.CreateOrganizationResponse.ReadOnly]
    }
    object OrganizationsMock extends zio.test.mock.Mock[Organizations] {
      object ListParents extends Stream[model.ListParentsRequest, AwsError, model.Parent.ReadOnly]
      object InviteAccountToOrganization extends Effect[model.InviteAccountToOrganizationRequest, AwsError, model.InviteAccountToOrganizationResponse.ReadOnly]
      object DescribeOrganization extends Effect[Unit, AwsError, model.DescribeOrganizationResponse.ReadOnly]
      object DescribePolicy extends Effect[model.DescribePolicyRequest, AwsError, model.DescribePolicyResponse.ReadOnly]
      object CreateAccount extends Effect[model.CreateAccountRequest, AwsError, model.CreateAccountResponse.ReadOnly]
      object MoveAccount extends Effect[model.MoveAccountRequest, AwsError, scala.Unit]
      object ListAccounts extends Stream[model.ListAccountsRequest, AwsError, model.Account.ReadOnly]
      object DeleteOrganizationalUnit extends Effect[model.DeleteOrganizationalUnitRequest, AwsError, scala.Unit]
      object EnableAllFeatures extends Effect[model.EnableAllFeaturesRequest, AwsError, model.EnableAllFeaturesResponse.ReadOnly]
      object CancelHandshake extends Effect[model.CancelHandshakeRequest, AwsError, model.CancelHandshakeResponse.ReadOnly]
      object ListAccountsForParent extends Stream[model.ListAccountsForParentRequest, AwsError, model.Account.ReadOnly]
      object EnablePolicyType extends Effect[model.EnablePolicyTypeRequest, AwsError, model.EnablePolicyTypeResponse.ReadOnly]
      object DisablePolicyType extends Effect[model.DisablePolicyTypeRequest, AwsError, model.DisablePolicyTypeResponse.ReadOnly]
      object DescribeOrganizationalUnit extends Effect[model.DescribeOrganizationalUnitRequest, AwsError, model.DescribeOrganizationalUnitResponse.ReadOnly]
      object ListHandshakesForOrganization extends Stream[model.ListHandshakesForOrganizationRequest, AwsError, model.Handshake.ReadOnly]
      object ListTargetsForPolicy extends Stream[model.ListTargetsForPolicyRequest, AwsError, model.PolicyTargetSummary.ReadOnly]
      object DetachPolicy extends Effect[model.DetachPolicyRequest, AwsError, scala.Unit]
      object UpdatePolicy extends Effect[model.UpdatePolicyRequest, AwsError, model.UpdatePolicyResponse.ReadOnly]
      object LeaveOrganization extends Effect[scala.Unit, AwsError, scala.Unit]
      object EnableAWSServiceAccess extends Effect[model.EnableAwsServiceAccessRequest, AwsError, scala.Unit]
      object DescribeAccount extends Effect[model.DescribeAccountRequest, AwsError, model.DescribeAccountResponse.ReadOnly]
      object DeleteOrganization extends Effect[scala.Unit, AwsError, scala.Unit]
      object CreateOrganizationalUnit extends Effect[model.CreateOrganizationalUnitRequest, AwsError, model.CreateOrganizationalUnitResponse.ReadOnly]
      object AcceptHandshake extends Effect[model.AcceptHandshakeRequest, AwsError, model.AcceptHandshakeResponse.ReadOnly]
      object ListPoliciesForTarget extends Stream[model.ListPoliciesForTargetRequest, AwsError, model.PolicySummary.ReadOnly]
      object ListOrganizationalUnitsForParent extends Stream[model.ListOrganizationalUnitsForParentRequest, AwsError, model.OrganizationalUnit.ReadOnly]
      object UpdateOrganizationalUnit extends Effect[model.UpdateOrganizationalUnitRequest, AwsError, model.UpdateOrganizationalUnitResponse.ReadOnly]
      object ListPolicies extends Stream[model.ListPoliciesRequest, AwsError, model.PolicySummary.ReadOnly]
      object DescribeHandshake extends Effect[model.DescribeHandshakeRequest, AwsError, model.DescribeHandshakeResponse.ReadOnly]
      object DescribeCreateAccountStatus extends Effect[model.DescribeCreateAccountStatusRequest, AwsError, model.DescribeCreateAccountStatusResponse.ReadOnly]
      object ListRoots extends Stream[model.ListRootsRequest, AwsError, model.Root.ReadOnly]
      object ListCreateAccountStatus extends Stream[model.ListCreateAccountStatusRequest, AwsError, model.CreateAccountStatus.ReadOnly]
      object UntagResource extends Effect[model.UntagResourceRequest, AwsError, scala.Unit]
      object RemoveAccountFromOrganization extends Effect[model.RemoveAccountFromOrganizationRequest, AwsError, scala.Unit]
      object ListAWSServiceAccessForOrganization extends Stream[model.ListAwsServiceAccessForOrganizationRequest, AwsError, model.EnabledServicePrincipal.ReadOnly]
      object DeregisterDelegatedAdministrator extends Effect[model.DeregisterDelegatedAdministratorRequest, AwsError, scala.Unit]
      object DeclineHandshake extends Effect[model.DeclineHandshakeRequest, AwsError, model.DeclineHandshakeResponse.ReadOnly]
      object AttachPolicy extends Effect[model.AttachPolicyRequest, AwsError, scala.Unit]
      object ListTagsForResource extends Stream[model.ListTagsForResourceRequest, AwsError, model.Tag.ReadOnly]
      object ListDelegatedServicesForAccount extends Stream[model.ListDelegatedServicesForAccountRequest, AwsError, model.DelegatedService.ReadOnly]
      object RegisterDelegatedAdministrator extends Effect[model.RegisterDelegatedAdministratorRequest, AwsError, scala.Unit]
      object DescribeEffectivePolicy extends Effect[model.DescribeEffectivePolicyRequest, AwsError, model.DescribeEffectivePolicyResponse.ReadOnly]
      object CreatePolicy extends Effect[model.CreatePolicyRequest, AwsError, model.CreatePolicyResponse.ReadOnly]
      object TagResource extends Effect[model.TagResourceRequest, AwsError, scala.Unit]
      object ListChildren extends Stream[model.ListChildrenRequest, AwsError, model.Child.ReadOnly]
      object DeletePolicy extends Effect[model.DeletePolicyRequest, AwsError, scala.Unit]
      object ListHandshakesForAccount extends Stream[model.ListHandshakesForAccountRequest, AwsError, model.Handshake.ReadOnly]
      object CreateGovCloudAccount extends Effect[model.CreateGovCloudAccountRequest, AwsError, model.CreateGovCloudAccountResponse.ReadOnly]
      object DisableAWSServiceAccess extends Effect[model.DisableAwsServiceAccessRequest, AwsError, scala.Unit]
      object ListDelegatedAdministrators extends Stream[model.ListDelegatedAdministratorsRequest, AwsError, model.DelegatedAdministrator.ReadOnly]
      object CreateOrganization extends Effect[model.CreateOrganizationRequest, AwsError, model.CreateOrganizationResponse.ReadOnly]
      val compose: URLayer[Has[zio.test.mock.Proxy], Organizations] = ZLayer.fromServiceM {
        proxy => withRuntime.map {
          rts => new Organizations.Service {
            val api: OrganizationsAsyncClient = null
            def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): Organizations.Service = this
            def listParents(request: model.ListParentsRequest): ZStream[Any, AwsError, model.Parent.ReadOnly] = rts.unsafeRun(proxy(ListParents, request))
            def inviteAccountToOrganization(request: model.InviteAccountToOrganizationRequest): IO[AwsError, model.InviteAccountToOrganizationResponse.ReadOnly] = proxy(InviteAccountToOrganization, request)
            def describeOrganization(): IO[AwsError, model.DescribeOrganizationResponse.ReadOnly] = proxy(DescribeOrganization)
            def describePolicy(request: model.DescribePolicyRequest): IO[AwsError, model.DescribePolicyResponse.ReadOnly] = proxy(DescribePolicy, request)
            def createAccount(request: model.CreateAccountRequest): IO[AwsError, model.CreateAccountResponse.ReadOnly] = proxy(CreateAccount, request)
            def moveAccount(request: model.MoveAccountRequest): IO[AwsError, scala.Unit] = proxy(MoveAccount, request)
            def listAccounts(request: model.ListAccountsRequest): ZStream[Any, AwsError, model.Account.ReadOnly] = rts.unsafeRun(proxy(ListAccounts, request))
            def deleteOrganizationalUnit(request: model.DeleteOrganizationalUnitRequest): IO[AwsError, scala.Unit] = proxy(DeleteOrganizationalUnit, request)
            def enableAllFeatures(request: model.EnableAllFeaturesRequest): IO[AwsError, model.EnableAllFeaturesResponse.ReadOnly] = proxy(EnableAllFeatures, request)
            def cancelHandshake(request: model.CancelHandshakeRequest): IO[AwsError, model.CancelHandshakeResponse.ReadOnly] = proxy(CancelHandshake, request)
            def listAccountsForParent(request: model.ListAccountsForParentRequest): ZStream[Any, AwsError, model.Account.ReadOnly] = rts.unsafeRun(proxy(ListAccountsForParent, request))
            def enablePolicyType(request: model.EnablePolicyTypeRequest): IO[AwsError, model.EnablePolicyTypeResponse.ReadOnly] = proxy(EnablePolicyType, request)
            def disablePolicyType(request: model.DisablePolicyTypeRequest): IO[AwsError, model.DisablePolicyTypeResponse.ReadOnly] = proxy(DisablePolicyType, request)
            def describeOrganizationalUnit(request: model.DescribeOrganizationalUnitRequest): IO[AwsError, model.DescribeOrganizationalUnitResponse.ReadOnly] = proxy(DescribeOrganizationalUnit, request)
            def listHandshakesForOrganization(request: model.ListHandshakesForOrganizationRequest): ZStream[Any, AwsError, model.Handshake.ReadOnly] = rts.unsafeRun(proxy(ListHandshakesForOrganization, request))
            def listTargetsForPolicy(request: model.ListTargetsForPolicyRequest): ZStream[Any, AwsError, model.PolicyTargetSummary.ReadOnly] = rts.unsafeRun(proxy(ListTargetsForPolicy, request))
            def detachPolicy(request: model.DetachPolicyRequest): IO[AwsError, scala.Unit] = proxy(DetachPolicy, request)
            def updatePolicy(request: model.UpdatePolicyRequest): IO[AwsError, model.UpdatePolicyResponse.ReadOnly] = proxy(UpdatePolicy, request)
            def leaveOrganization(): IO[AwsError, scala.Unit] = proxy(LeaveOrganization)
            def enableAWSServiceAccess(request: model.EnableAwsServiceAccessRequest): IO[AwsError, scala.Unit] = proxy(EnableAWSServiceAccess, request)
            def describeAccount(request: model.DescribeAccountRequest): IO[AwsError, model.DescribeAccountResponse.ReadOnly] = proxy(DescribeAccount, request)
            def deleteOrganization(): IO[AwsError, scala.Unit] = proxy(DeleteOrganization)
            def createOrganizationalUnit(request: model.CreateOrganizationalUnitRequest): IO[AwsError, model.CreateOrganizationalUnitResponse.ReadOnly] = proxy(CreateOrganizationalUnit, request)
            def acceptHandshake(request: model.AcceptHandshakeRequest): IO[AwsError, model.AcceptHandshakeResponse.ReadOnly] = proxy(AcceptHandshake, request)
            def listPoliciesForTarget(request: model.ListPoliciesForTargetRequest): ZStream[Any, AwsError, model.PolicySummary.ReadOnly] = rts.unsafeRun(proxy(ListPoliciesForTarget, request))
            def listOrganizationalUnitsForParent(request: model.ListOrganizationalUnitsForParentRequest): ZStream[Any, AwsError, model.OrganizationalUnit.ReadOnly] = rts.unsafeRun(proxy(ListOrganizationalUnitsForParent, request))
            def updateOrganizationalUnit(request: model.UpdateOrganizationalUnitRequest): IO[AwsError, model.UpdateOrganizationalUnitResponse.ReadOnly] = proxy(UpdateOrganizationalUnit, request)
            def listPolicies(request: model.ListPoliciesRequest): ZStream[Any, AwsError, model.PolicySummary.ReadOnly] = rts.unsafeRun(proxy(ListPolicies, request))
            def describeHandshake(request: model.DescribeHandshakeRequest): IO[AwsError, model.DescribeHandshakeResponse.ReadOnly] = proxy(DescribeHandshake, request)
            def describeCreateAccountStatus(request: model.DescribeCreateAccountStatusRequest): IO[AwsError, model.DescribeCreateAccountStatusResponse.ReadOnly] = proxy(DescribeCreateAccountStatus, request)
            def listRoots(request: model.ListRootsRequest): ZStream[Any, AwsError, model.Root.ReadOnly] = rts.unsafeRun(proxy(ListRoots, request))
            def listCreateAccountStatus(request: model.ListCreateAccountStatusRequest): ZStream[Any, AwsError, model.CreateAccountStatus.ReadOnly] = rts.unsafeRun(proxy(ListCreateAccountStatus, request))
            def untagResource(request: model.UntagResourceRequest): IO[AwsError, scala.Unit] = proxy(UntagResource, request)
            def removeAccountFromOrganization(request: model.RemoveAccountFromOrganizationRequest): IO[AwsError, scala.Unit] = proxy(RemoveAccountFromOrganization, request)
            def listAWSServiceAccessForOrganization(request: model.ListAwsServiceAccessForOrganizationRequest): ZStream[Any, AwsError, model.EnabledServicePrincipal.ReadOnly] = rts.unsafeRun(proxy(ListAWSServiceAccessForOrganization, request))
            def deregisterDelegatedAdministrator(request: model.DeregisterDelegatedAdministratorRequest): IO[AwsError, scala.Unit] = proxy(DeregisterDelegatedAdministrator, request)
            def declineHandshake(request: model.DeclineHandshakeRequest): IO[AwsError, model.DeclineHandshakeResponse.ReadOnly] = proxy(DeclineHandshake, request)
            def attachPolicy(request: model.AttachPolicyRequest): IO[AwsError, scala.Unit] = proxy(AttachPolicy, request)
            def listTagsForResource(request: model.ListTagsForResourceRequest): ZStream[Any, AwsError, model.Tag.ReadOnly] = rts.unsafeRun(proxy(ListTagsForResource, request))
            def listDelegatedServicesForAccount(request: model.ListDelegatedServicesForAccountRequest): ZStream[Any, AwsError, model.DelegatedService.ReadOnly] = rts.unsafeRun(proxy(ListDelegatedServicesForAccount, request))
            def registerDelegatedAdministrator(request: model.RegisterDelegatedAdministratorRequest): IO[AwsError, scala.Unit] = proxy(RegisterDelegatedAdministrator, request)
            def describeEffectivePolicy(request: model.DescribeEffectivePolicyRequest): IO[AwsError, model.DescribeEffectivePolicyResponse.ReadOnly] = proxy(DescribeEffectivePolicy, request)
            def createPolicy(request: model.CreatePolicyRequest): IO[AwsError, model.CreatePolicyResponse.ReadOnly] = proxy(CreatePolicy, request)
            def tagResource(request: model.TagResourceRequest): IO[AwsError, scala.Unit] = proxy(TagResource, request)
            def listChildren(request: model.ListChildrenRequest): ZStream[Any, AwsError, model.Child.ReadOnly] = rts.unsafeRun(proxy(ListChildren, request))
            def deletePolicy(request: model.DeletePolicyRequest): IO[AwsError, scala.Unit] = proxy(DeletePolicy, request)
            def listHandshakesForAccount(request: model.ListHandshakesForAccountRequest): ZStream[Any, AwsError, model.Handshake.ReadOnly] = rts.unsafeRun(proxy(ListHandshakesForAccount, request))
            def createGovCloudAccount(request: model.CreateGovCloudAccountRequest): IO[AwsError, model.CreateGovCloudAccountResponse.ReadOnly] = proxy(CreateGovCloudAccount, request)
            def disableAWSServiceAccess(request: model.DisableAwsServiceAccessRequest): IO[AwsError, scala.Unit] = proxy(DisableAWSServiceAccess, request)
            def listDelegatedAdministrators(request: model.ListDelegatedAdministratorsRequest): ZStream[Any, AwsError, model.DelegatedAdministrator.ReadOnly] = rts.unsafeRun(proxy(ListDelegatedAdministrators, request))
            def createOrganization(request: model.CreateOrganizationRequest): IO[AwsError, model.CreateOrganizationResponse.ReadOnly] = proxy(CreateOrganization, request)
          }
        }
      }
    }
  }
  val live: ZLayer[AwsConfig, Throwable, Organizations] = customized(identity)
  def customized(customization: OrganizationsAsyncClientBuilder => OrganizationsAsyncClientBuilder): ZLayer[AwsConfig, Throwable, Organizations] = managed(customization).toLayer
  def managed(customization: OrganizationsAsyncClientBuilder => OrganizationsAsyncClientBuilder): ZManaged[AwsConfig, Throwable, Organizations.Service] = for (awsConfig <- ZManaged.service[AwsConfig.Service]; executor <- ZIO.executor.toManaged_; builder = OrganizationsAsyncClient.builder().asyncConfiguration(ClientAsyncConfiguration.builder().advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, executor.asJava).build()); b0 <- awsConfig.configure[OrganizationsAsyncClient, OrganizationsAsyncClientBuilder](builder).toManaged_; b1 <- awsConfig.configureHttpClient[OrganizationsAsyncClient, OrganizationsAsyncClientBuilder](b0, ServiceHttpCapabilities(supportsHttp2 = false)).toManaged_; client <- ZIO(customization(b1).build()).toManaged_) yield new OrganizationsImpl(client, AwsCallAspect.identity, ().asInstanceOf[Any])
  private class OrganizationsImpl[R](override val api: OrganizationsAsyncClient, override val aspect: AwsCallAspect[R], r: R) extends Organizations.Service with AwsServiceBase[R, OrganizationsImpl] {
    override val serviceName: String = "Organizations"
    override def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): OrganizationsImpl[R1] = new OrganizationsImpl(api, newAspect, r)
    def listParents(request: model.ListParentsRequest): ZStream[Any, AwsError, model.Parent.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.organizations.model.ListParentsRequest, software.amazon.awssdk.services.organizations.model.ListParentsResponse, software.amazon.awssdk.services.organizations.model.Parent]("listParents", api.listParents, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.parents().asScala))(request.buildAwsValue()).map(item => model.Parent.wrap(item)).provide(r)
    def inviteAccountToOrganization(request: model.InviteAccountToOrganizationRequest): IO[AwsError, model.InviteAccountToOrganizationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationRequest, software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationResponse]("inviteAccountToOrganization", api.inviteAccountToOrganization)(request.buildAwsValue()).map(model.InviteAccountToOrganizationResponse.wrap).provide(r)
    def describeOrganization(): IO[AwsError, model.DescribeOrganizationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.DescribeOrganizationRequest, software.amazon.awssdk.services.organizations.model.DescribeOrganizationResponse]("describeOrganization", api.describeOrganization)(software.amazon.awssdk.services.organizations.model.DescribeOrganizationRequest.builder().build()).map(model.DescribeOrganizationResponse.wrap).provide(r)
    def describePolicy(request: model.DescribePolicyRequest): IO[AwsError, model.DescribePolicyResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.DescribePolicyRequest, software.amazon.awssdk.services.organizations.model.DescribePolicyResponse]("describePolicy", api.describePolicy)(request.buildAwsValue()).map(model.DescribePolicyResponse.wrap).provide(r)
    def createAccount(request: model.CreateAccountRequest): IO[AwsError, model.CreateAccountResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.CreateAccountRequest, software.amazon.awssdk.services.organizations.model.CreateAccountResponse]("createAccount", api.createAccount)(request.buildAwsValue()).map(model.CreateAccountResponse.wrap).provide(r)
    def moveAccount(request: model.MoveAccountRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.MoveAccountRequest, software.amazon.awssdk.services.organizations.model.MoveAccountResponse]("moveAccount", api.moveAccount)(request.buildAwsValue()).unit.provide(r)
    def listAccounts(request: model.ListAccountsRequest): ZStream[Any, AwsError, model.Account.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.organizations.model.ListAccountsRequest, software.amazon.awssdk.services.organizations.model.ListAccountsResponse, software.amazon.awssdk.services.organizations.model.Account]("listAccounts", api.listAccounts, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.accounts().asScala))(request.buildAwsValue()).map(item => model.Account.wrap(item)).provide(r)
    def deleteOrganizationalUnit(request: model.DeleteOrganizationalUnitRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.DeleteOrganizationalUnitRequest, software.amazon.awssdk.services.organizations.model.DeleteOrganizationalUnitResponse]("deleteOrganizationalUnit", api.deleteOrganizationalUnit)(request.buildAwsValue()).unit.provide(r)
    def enableAllFeatures(request: model.EnableAllFeaturesRequest): IO[AwsError, model.EnableAllFeaturesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.EnableAllFeaturesRequest, software.amazon.awssdk.services.organizations.model.EnableAllFeaturesResponse]("enableAllFeatures", api.enableAllFeatures)(request.buildAwsValue()).map(model.EnableAllFeaturesResponse.wrap).provide(r)
    def cancelHandshake(request: model.CancelHandshakeRequest): IO[AwsError, model.CancelHandshakeResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.CancelHandshakeRequest, software.amazon.awssdk.services.organizations.model.CancelHandshakeResponse]("cancelHandshake", api.cancelHandshake)(request.buildAwsValue()).map(model.CancelHandshakeResponse.wrap).provide(r)
    def listAccountsForParent(request: model.ListAccountsForParentRequest): ZStream[Any, AwsError, model.Account.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.organizations.model.ListAccountsForParentRequest, software.amazon.awssdk.services.organizations.model.ListAccountsForParentResponse, software.amazon.awssdk.services.organizations.model.Account]("listAccountsForParent", api.listAccountsForParent, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.accounts().asScala))(request.buildAwsValue()).map(item => model.Account.wrap(item)).provide(r)
    def enablePolicyType(request: model.EnablePolicyTypeRequest): IO[AwsError, model.EnablePolicyTypeResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.EnablePolicyTypeRequest, software.amazon.awssdk.services.organizations.model.EnablePolicyTypeResponse]("enablePolicyType", api.enablePolicyType)(request.buildAwsValue()).map(model.EnablePolicyTypeResponse.wrap).provide(r)
    def disablePolicyType(request: model.DisablePolicyTypeRequest): IO[AwsError, model.DisablePolicyTypeResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.DisablePolicyTypeRequest, software.amazon.awssdk.services.organizations.model.DisablePolicyTypeResponse]("disablePolicyType", api.disablePolicyType)(request.buildAwsValue()).map(model.DisablePolicyTypeResponse.wrap).provide(r)
    def describeOrganizationalUnit(request: model.DescribeOrganizationalUnitRequest): IO[AwsError, model.DescribeOrganizationalUnitResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitRequest, software.amazon.awssdk.services.organizations.model.DescribeOrganizationalUnitResponse]("describeOrganizationalUnit", api.describeOrganizationalUnit)(request.buildAwsValue()).map(model.DescribeOrganizationalUnitResponse.wrap).provide(r)
    def listHandshakesForOrganization(request: model.ListHandshakesForOrganizationRequest): ZStream[Any, AwsError, model.Handshake.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationRequest, software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationResponse, software.amazon.awssdk.services.organizations.model.Handshake]("listHandshakesForOrganization", api.listHandshakesForOrganization, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.handshakes().asScala))(request.buildAwsValue()).map(item => model.Handshake.wrap(item)).provide(r)
    def listTargetsForPolicy(request: model.ListTargetsForPolicyRequest): ZStream[Any, AwsError, model.PolicyTargetSummary.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyRequest, software.amazon.awssdk.services.organizations.model.ListTargetsForPolicyResponse, software.amazon.awssdk.services.organizations.model.PolicyTargetSummary]("listTargetsForPolicy", api.listTargetsForPolicy, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.targets().asScala))(request.buildAwsValue()).map(item => model.PolicyTargetSummary.wrap(item)).provide(r)
    def detachPolicy(request: model.DetachPolicyRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.DetachPolicyRequest, software.amazon.awssdk.services.organizations.model.DetachPolicyResponse]("detachPolicy", api.detachPolicy)(request.buildAwsValue()).unit.provide(r)
    def updatePolicy(request: model.UpdatePolicyRequest): IO[AwsError, model.UpdatePolicyResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.UpdatePolicyRequest, software.amazon.awssdk.services.organizations.model.UpdatePolicyResponse]("updatePolicy", api.updatePolicy)(request.buildAwsValue()).map(model.UpdatePolicyResponse.wrap).provide(r)
    def leaveOrganization(): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.LeaveOrganizationRequest, software.amazon.awssdk.services.organizations.model.LeaveOrganizationResponse]("leaveOrganization", api.leaveOrganization)(software.amazon.awssdk.services.organizations.model.LeaveOrganizationRequest.builder().build()).unit.provide(r)
    def enableAWSServiceAccess(request: model.EnableAwsServiceAccessRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.EnableAwsServiceAccessRequest, software.amazon.awssdk.services.organizations.model.EnableAwsServiceAccessResponse]("enableAWSServiceAccess", api.enableAWSServiceAccess)(request.buildAwsValue()).unit.provide(r)
    def describeAccount(request: model.DescribeAccountRequest): IO[AwsError, model.DescribeAccountResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.DescribeAccountRequest, software.amazon.awssdk.services.organizations.model.DescribeAccountResponse]("describeAccount", api.describeAccount)(request.buildAwsValue()).map(model.DescribeAccountResponse.wrap).provide(r)
    def deleteOrganization(): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.DeleteOrganizationRequest, software.amazon.awssdk.services.organizations.model.DeleteOrganizationResponse]("deleteOrganization", api.deleteOrganization)(software.amazon.awssdk.services.organizations.model.DeleteOrganizationRequest.builder().build()).unit.provide(r)
    def createOrganizationalUnit(request: model.CreateOrganizationalUnitRequest): IO[AwsError, model.CreateOrganizationalUnitResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitRequest, software.amazon.awssdk.services.organizations.model.CreateOrganizationalUnitResponse]("createOrganizationalUnit", api.createOrganizationalUnit)(request.buildAwsValue()).map(model.CreateOrganizationalUnitResponse.wrap).provide(r)
    def acceptHandshake(request: model.AcceptHandshakeRequest): IO[AwsError, model.AcceptHandshakeResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.AcceptHandshakeRequest, software.amazon.awssdk.services.organizations.model.AcceptHandshakeResponse]("acceptHandshake", api.acceptHandshake)(request.buildAwsValue()).map(model.AcceptHandshakeResponse.wrap).provide(r)
    def listPoliciesForTarget(request: model.ListPoliciesForTargetRequest): ZStream[Any, AwsError, model.PolicySummary.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetRequest, software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse, software.amazon.awssdk.services.organizations.model.PolicySummary]("listPoliciesForTarget", api.listPoliciesForTarget, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.policies().asScala))(request.buildAwsValue()).map(item => model.PolicySummary.wrap(item)).provide(r)
    def listOrganizationalUnitsForParent(request: model.ListOrganizationalUnitsForParentRequest): ZStream[Any, AwsError, model.OrganizationalUnit.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentRequest, software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentResponse, software.amazon.awssdk.services.organizations.model.OrganizationalUnit]("listOrganizationalUnitsForParent", api.listOrganizationalUnitsForParent, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.organizationalUnits().asScala))(request.buildAwsValue()).map(item => model.OrganizationalUnit.wrap(item)).provide(r)
    def updateOrganizationalUnit(request: model.UpdateOrganizationalUnitRequest): IO[AwsError, model.UpdateOrganizationalUnitResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitRequest, software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitResponse]("updateOrganizationalUnit", api.updateOrganizationalUnit)(request.buildAwsValue()).map(model.UpdateOrganizationalUnitResponse.wrap).provide(r)
    def listPolicies(request: model.ListPoliciesRequest): ZStream[Any, AwsError, model.PolicySummary.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.organizations.model.ListPoliciesRequest, software.amazon.awssdk.services.organizations.model.ListPoliciesResponse, software.amazon.awssdk.services.organizations.model.PolicySummary]("listPolicies", api.listPolicies, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.policies().asScala))(request.buildAwsValue()).map(item => model.PolicySummary.wrap(item)).provide(r)
    def describeHandshake(request: model.DescribeHandshakeRequest): IO[AwsError, model.DescribeHandshakeResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.DescribeHandshakeRequest, software.amazon.awssdk.services.organizations.model.DescribeHandshakeResponse]("describeHandshake", api.describeHandshake)(request.buildAwsValue()).map(model.DescribeHandshakeResponse.wrap).provide(r)
    def describeCreateAccountStatus(request: model.DescribeCreateAccountStatusRequest): IO[AwsError, model.DescribeCreateAccountStatusResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusRequest, software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusResponse]("describeCreateAccountStatus", api.describeCreateAccountStatus)(request.buildAwsValue()).map(model.DescribeCreateAccountStatusResponse.wrap).provide(r)
    def listRoots(request: model.ListRootsRequest): ZStream[Any, AwsError, model.Root.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.organizations.model.ListRootsRequest, software.amazon.awssdk.services.organizations.model.ListRootsResponse, software.amazon.awssdk.services.organizations.model.Root]("listRoots", api.listRoots, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.roots().asScala))(request.buildAwsValue()).map(item => model.Root.wrap(item)).provide(r)
    def listCreateAccountStatus(request: model.ListCreateAccountStatusRequest): ZStream[Any, AwsError, model.CreateAccountStatus.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest, software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusResponse, software.amazon.awssdk.services.organizations.model.CreateAccountStatus]("listCreateAccountStatus", api.listCreateAccountStatus, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.createAccountStatuses().asScala))(request.buildAwsValue()).map(item => model.CreateAccountStatus.wrap(item)).provide(r)
    def untagResource(request: model.UntagResourceRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.UntagResourceRequest, software.amazon.awssdk.services.organizations.model.UntagResourceResponse]("untagResource", api.untagResource)(request.buildAwsValue()).unit.provide(r)
    def removeAccountFromOrganization(request: model.RemoveAccountFromOrganizationRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationRequest, software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationResponse]("removeAccountFromOrganization", api.removeAccountFromOrganization)(request.buildAwsValue()).unit.provide(r)
    def listAWSServiceAccessForOrganization(request: model.ListAwsServiceAccessForOrganizationRequest): ZStream[Any, AwsError, model.EnabledServicePrincipal.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationRequest, software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationResponse, software.amazon.awssdk.services.organizations.model.EnabledServicePrincipal]("listAWSServiceAccessForOrganization", api.listAWSServiceAccessForOrganization, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.enabledServicePrincipals().asScala))(request.buildAwsValue()).map(item => model.EnabledServicePrincipal.wrap(item)).provide(r)
    def deregisterDelegatedAdministrator(request: model.DeregisterDelegatedAdministratorRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.DeregisterDelegatedAdministratorRequest, software.amazon.awssdk.services.organizations.model.DeregisterDelegatedAdministratorResponse]("deregisterDelegatedAdministrator", api.deregisterDelegatedAdministrator)(request.buildAwsValue()).unit.provide(r)
    def declineHandshake(request: model.DeclineHandshakeRequest): IO[AwsError, model.DeclineHandshakeResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.DeclineHandshakeRequest, software.amazon.awssdk.services.organizations.model.DeclineHandshakeResponse]("declineHandshake", api.declineHandshake)(request.buildAwsValue()).map(model.DeclineHandshakeResponse.wrap).provide(r)
    def attachPolicy(request: model.AttachPolicyRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.AttachPolicyRequest, software.amazon.awssdk.services.organizations.model.AttachPolicyResponse]("attachPolicy", api.attachPolicy)(request.buildAwsValue()).unit.provide(r)
    def listTagsForResource(request: model.ListTagsForResourceRequest): ZStream[Any, AwsError, model.Tag.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.organizations.model.ListTagsForResourceRequest, software.amazon.awssdk.services.organizations.model.ListTagsForResourceResponse, software.amazon.awssdk.services.organizations.model.Tag]("listTagsForResource", api.listTagsForResource, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.tags().asScala))(request.buildAwsValue()).map(item => model.Tag.wrap(item)).provide(r)
    def listDelegatedServicesForAccount(request: model.ListDelegatedServicesForAccountRequest): ZStream[Any, AwsError, model.DelegatedService.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountRequest, software.amazon.awssdk.services.organizations.model.ListDelegatedServicesForAccountResponse, software.amazon.awssdk.services.organizations.model.DelegatedService]("listDelegatedServicesForAccount", api.listDelegatedServicesForAccount, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.delegatedServices().asScala))(request.buildAwsValue()).map(item => model.DelegatedService.wrap(item)).provide(r)
    def registerDelegatedAdministrator(request: model.RegisterDelegatedAdministratorRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.RegisterDelegatedAdministratorRequest, software.amazon.awssdk.services.organizations.model.RegisterDelegatedAdministratorResponse]("registerDelegatedAdministrator", api.registerDelegatedAdministrator)(request.buildAwsValue()).unit.provide(r)
    def describeEffectivePolicy(request: model.DescribeEffectivePolicyRequest): IO[AwsError, model.DescribeEffectivePolicyResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyRequest, software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyResponse]("describeEffectivePolicy", api.describeEffectivePolicy)(request.buildAwsValue()).map(model.DescribeEffectivePolicyResponse.wrap).provide(r)
    def createPolicy(request: model.CreatePolicyRequest): IO[AwsError, model.CreatePolicyResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.CreatePolicyRequest, software.amazon.awssdk.services.organizations.model.CreatePolicyResponse]("createPolicy", api.createPolicy)(request.buildAwsValue()).map(model.CreatePolicyResponse.wrap).provide(r)
    def tagResource(request: model.TagResourceRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.TagResourceRequest, software.amazon.awssdk.services.organizations.model.TagResourceResponse]("tagResource", api.tagResource)(request.buildAwsValue()).unit.provide(r)
    def listChildren(request: model.ListChildrenRequest): ZStream[Any, AwsError, model.Child.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.organizations.model.ListChildrenRequest, software.amazon.awssdk.services.organizations.model.ListChildrenResponse, software.amazon.awssdk.services.organizations.model.Child]("listChildren", api.listChildren, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.children().asScala))(request.buildAwsValue()).map(item => model.Child.wrap(item)).provide(r)
    def deletePolicy(request: model.DeletePolicyRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.DeletePolicyRequest, software.amazon.awssdk.services.organizations.model.DeletePolicyResponse]("deletePolicy", api.deletePolicy)(request.buildAwsValue()).unit.provide(r)
    def listHandshakesForAccount(request: model.ListHandshakesForAccountRequest): ZStream[Any, AwsError, model.Handshake.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountRequest, software.amazon.awssdk.services.organizations.model.ListHandshakesForAccountResponse, software.amazon.awssdk.services.organizations.model.Handshake]("listHandshakesForAccount", api.listHandshakesForAccount, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.handshakes().asScala))(request.buildAwsValue()).map(item => model.Handshake.wrap(item)).provide(r)
    def createGovCloudAccount(request: model.CreateGovCloudAccountRequest): IO[AwsError, model.CreateGovCloudAccountResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.CreateGovCloudAccountRequest, software.amazon.awssdk.services.organizations.model.CreateGovCloudAccountResponse]("createGovCloudAccount", api.createGovCloudAccount)(request.buildAwsValue()).map(model.CreateGovCloudAccountResponse.wrap).provide(r)
    def disableAWSServiceAccess(request: model.DisableAwsServiceAccessRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessRequest, software.amazon.awssdk.services.organizations.model.DisableAwsServiceAccessResponse]("disableAWSServiceAccess", api.disableAWSServiceAccess)(request.buildAwsValue()).unit.provide(r)
    def listDelegatedAdministrators(request: model.ListDelegatedAdministratorsRequest): ZStream[Any, AwsError, model.DelegatedAdministrator.ReadOnly] = asyncSimplePaginatedRequest[software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsRequest, software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsResponse, software.amazon.awssdk.services.organizations.model.DelegatedAdministrator]("listDelegatedAdministrators", api.listDelegatedAdministrators, (r, token) => r.toBuilder().nextToken(token).build(), r => Option(r.nextToken()), r => Chunk.fromIterable(r.delegatedAdministrators().asScala))(request.buildAwsValue()).map(item => model.DelegatedAdministrator.wrap(item)).provide(r)
    def createOrganization(request: model.CreateOrganizationRequest): IO[AwsError, model.CreateOrganizationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.organizations.model.CreateOrganizationRequest, software.amazon.awssdk.services.organizations.model.CreateOrganizationResponse]("createOrganization", api.createOrganization)(request.buildAwsValue()).map(model.CreateOrganizationResponse.wrap).provide(r)
  }
  def listParents(request: model.ListParentsRequest): ZStream[Organizations, AwsError, model.Parent.ReadOnly] = ZStream.accessStream(_.get.listParents(request))
  def inviteAccountToOrganization(request: model.InviteAccountToOrganizationRequest): ZIO[Organizations, AwsError, model.InviteAccountToOrganizationResponse.ReadOnly] = ZIO.accessM(_.get.inviteAccountToOrganization(request))
  def describeOrganization(): ZIO[Organizations, AwsError, model.DescribeOrganizationResponse.ReadOnly] = ZIO.accessM(_.get.describeOrganization())
  def describePolicy(request: model.DescribePolicyRequest): ZIO[Organizations, AwsError, model.DescribePolicyResponse.ReadOnly] = ZIO.accessM(_.get.describePolicy(request))
  def createAccount(request: model.CreateAccountRequest): ZIO[Organizations, AwsError, model.CreateAccountResponse.ReadOnly] = ZIO.accessM(_.get.createAccount(request))
  def moveAccount(request: model.MoveAccountRequest): ZIO[Organizations, AwsError, scala.Unit] = ZIO.accessM(_.get.moveAccount(request))
  def listAccounts(request: model.ListAccountsRequest): ZStream[Organizations, AwsError, model.Account.ReadOnly] = ZStream.accessStream(_.get.listAccounts(request))
  def deleteOrganizationalUnit(request: model.DeleteOrganizationalUnitRequest): ZIO[Organizations, AwsError, scala.Unit] = ZIO.accessM(_.get.deleteOrganizationalUnit(request))
  def enableAllFeatures(request: model.EnableAllFeaturesRequest): ZIO[Organizations, AwsError, model.EnableAllFeaturesResponse.ReadOnly] = ZIO.accessM(_.get.enableAllFeatures(request))
  def cancelHandshake(request: model.CancelHandshakeRequest): ZIO[Organizations, AwsError, model.CancelHandshakeResponse.ReadOnly] = ZIO.accessM(_.get.cancelHandshake(request))
  def listAccountsForParent(request: model.ListAccountsForParentRequest): ZStream[Organizations, AwsError, model.Account.ReadOnly] = ZStream.accessStream(_.get.listAccountsForParent(request))
  def enablePolicyType(request: model.EnablePolicyTypeRequest): ZIO[Organizations, AwsError, model.EnablePolicyTypeResponse.ReadOnly] = ZIO.accessM(_.get.enablePolicyType(request))
  def disablePolicyType(request: model.DisablePolicyTypeRequest): ZIO[Organizations, AwsError, model.DisablePolicyTypeResponse.ReadOnly] = ZIO.accessM(_.get.disablePolicyType(request))
  def describeOrganizationalUnit(request: model.DescribeOrganizationalUnitRequest): ZIO[Organizations, AwsError, model.DescribeOrganizationalUnitResponse.ReadOnly] = ZIO.accessM(_.get.describeOrganizationalUnit(request))
  def listHandshakesForOrganization(request: model.ListHandshakesForOrganizationRequest): ZStream[Organizations, AwsError, model.Handshake.ReadOnly] = ZStream.accessStream(_.get.listHandshakesForOrganization(request))
  def listTargetsForPolicy(request: model.ListTargetsForPolicyRequest): ZStream[Organizations, AwsError, model.PolicyTargetSummary.ReadOnly] = ZStream.accessStream(_.get.listTargetsForPolicy(request))
  def detachPolicy(request: model.DetachPolicyRequest): ZIO[Organizations, AwsError, scala.Unit] = ZIO.accessM(_.get.detachPolicy(request))
  def updatePolicy(request: model.UpdatePolicyRequest): ZIO[Organizations, AwsError, model.UpdatePolicyResponse.ReadOnly] = ZIO.accessM(_.get.updatePolicy(request))
  def leaveOrganization(): ZIO[Organizations, AwsError, scala.Unit] = ZIO.accessM(_.get.leaveOrganization())
  def enableAWSServiceAccess(request: model.EnableAwsServiceAccessRequest): ZIO[Organizations, AwsError, scala.Unit] = ZIO.accessM(_.get.enableAWSServiceAccess(request))
  def describeAccount(request: model.DescribeAccountRequest): ZIO[Organizations, AwsError, model.DescribeAccountResponse.ReadOnly] = ZIO.accessM(_.get.describeAccount(request))
  def deleteOrganization(): ZIO[Organizations, AwsError, scala.Unit] = ZIO.accessM(_.get.deleteOrganization())
  def createOrganizationalUnit(request: model.CreateOrganizationalUnitRequest): ZIO[Organizations, AwsError, model.CreateOrganizationalUnitResponse.ReadOnly] = ZIO.accessM(_.get.createOrganizationalUnit(request))
  def acceptHandshake(request: model.AcceptHandshakeRequest): ZIO[Organizations, AwsError, model.AcceptHandshakeResponse.ReadOnly] = ZIO.accessM(_.get.acceptHandshake(request))
  def listPoliciesForTarget(request: model.ListPoliciesForTargetRequest): ZStream[Organizations, AwsError, model.PolicySummary.ReadOnly] = ZStream.accessStream(_.get.listPoliciesForTarget(request))
  def listOrganizationalUnitsForParent(request: model.ListOrganizationalUnitsForParentRequest): ZStream[Organizations, AwsError, model.OrganizationalUnit.ReadOnly] = ZStream.accessStream(_.get.listOrganizationalUnitsForParent(request))
  def updateOrganizationalUnit(request: model.UpdateOrganizationalUnitRequest): ZIO[Organizations, AwsError, model.UpdateOrganizationalUnitResponse.ReadOnly] = ZIO.accessM(_.get.updateOrganizationalUnit(request))
  def listPolicies(request: model.ListPoliciesRequest): ZStream[Organizations, AwsError, model.PolicySummary.ReadOnly] = ZStream.accessStream(_.get.listPolicies(request))
  def describeHandshake(request: model.DescribeHandshakeRequest): ZIO[Organizations, AwsError, model.DescribeHandshakeResponse.ReadOnly] = ZIO.accessM(_.get.describeHandshake(request))
  def describeCreateAccountStatus(request: model.DescribeCreateAccountStatusRequest): ZIO[Organizations, AwsError, model.DescribeCreateAccountStatusResponse.ReadOnly] = ZIO.accessM(_.get.describeCreateAccountStatus(request))
  def listRoots(request: model.ListRootsRequest): ZStream[Organizations, AwsError, model.Root.ReadOnly] = ZStream.accessStream(_.get.listRoots(request))
  def listCreateAccountStatus(request: model.ListCreateAccountStatusRequest): ZStream[Organizations, AwsError, model.CreateAccountStatus.ReadOnly] = ZStream.accessStream(_.get.listCreateAccountStatus(request))
  def untagResource(request: model.UntagResourceRequest): ZIO[Organizations, AwsError, scala.Unit] = ZIO.accessM(_.get.untagResource(request))
  def removeAccountFromOrganization(request: model.RemoveAccountFromOrganizationRequest): ZIO[Organizations, AwsError, scala.Unit] = ZIO.accessM(_.get.removeAccountFromOrganization(request))
  def listAWSServiceAccessForOrganization(request: model.ListAwsServiceAccessForOrganizationRequest): ZStream[Organizations, AwsError, model.EnabledServicePrincipal.ReadOnly] = ZStream.accessStream(_.get.listAWSServiceAccessForOrganization(request))
  def deregisterDelegatedAdministrator(request: model.DeregisterDelegatedAdministratorRequest): ZIO[Organizations, AwsError, scala.Unit] = ZIO.accessM(_.get.deregisterDelegatedAdministrator(request))
  def declineHandshake(request: model.DeclineHandshakeRequest): ZIO[Organizations, AwsError, model.DeclineHandshakeResponse.ReadOnly] = ZIO.accessM(_.get.declineHandshake(request))
  def attachPolicy(request: model.AttachPolicyRequest): ZIO[Organizations, AwsError, scala.Unit] = ZIO.accessM(_.get.attachPolicy(request))
  def listTagsForResource(request: model.ListTagsForResourceRequest): ZStream[Organizations, AwsError, model.Tag.ReadOnly] = ZStream.accessStream(_.get.listTagsForResource(request))
  def listDelegatedServicesForAccount(request: model.ListDelegatedServicesForAccountRequest): ZStream[Organizations, AwsError, model.DelegatedService.ReadOnly] = ZStream.accessStream(_.get.listDelegatedServicesForAccount(request))
  def registerDelegatedAdministrator(request: model.RegisterDelegatedAdministratorRequest): ZIO[Organizations, AwsError, scala.Unit] = ZIO.accessM(_.get.registerDelegatedAdministrator(request))
  def describeEffectivePolicy(request: model.DescribeEffectivePolicyRequest): ZIO[Organizations, AwsError, model.DescribeEffectivePolicyResponse.ReadOnly] = ZIO.accessM(_.get.describeEffectivePolicy(request))
  def createPolicy(request: model.CreatePolicyRequest): ZIO[Organizations, AwsError, model.CreatePolicyResponse.ReadOnly] = ZIO.accessM(_.get.createPolicy(request))
  def tagResource(request: model.TagResourceRequest): ZIO[Organizations, AwsError, scala.Unit] = ZIO.accessM(_.get.tagResource(request))
  def listChildren(request: model.ListChildrenRequest): ZStream[Organizations, AwsError, model.Child.ReadOnly] = ZStream.accessStream(_.get.listChildren(request))
  def deletePolicy(request: model.DeletePolicyRequest): ZIO[Organizations, AwsError, scala.Unit] = ZIO.accessM(_.get.deletePolicy(request))
  def listHandshakesForAccount(request: model.ListHandshakesForAccountRequest): ZStream[Organizations, AwsError, model.Handshake.ReadOnly] = ZStream.accessStream(_.get.listHandshakesForAccount(request))
  def createGovCloudAccount(request: model.CreateGovCloudAccountRequest): ZIO[Organizations, AwsError, model.CreateGovCloudAccountResponse.ReadOnly] = ZIO.accessM(_.get.createGovCloudAccount(request))
  def disableAWSServiceAccess(request: model.DisableAwsServiceAccessRequest): ZIO[Organizations, AwsError, scala.Unit] = ZIO.accessM(_.get.disableAWSServiceAccess(request))
  def listDelegatedAdministrators(request: model.ListDelegatedAdministratorsRequest): ZStream[Organizations, AwsError, model.DelegatedAdministrator.ReadOnly] = ZStream.accessStream(_.get.listDelegatedAdministrators(request))
  def createOrganization(request: model.CreateOrganizationRequest): ZIO[Organizations, AwsError, model.CreateOrganizationResponse.ReadOnly] = ZIO.accessM(_.get.createOrganization(request))
}