package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Root(id: scala.Option[primitives.RootId] = None, arn: scala.Option[primitives.RootArn] = None, name: scala.Option[primitives.RootName] = None, policyTypes: scala.Option[Iterable[PolicyTypeSummary]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.Root = {
    import Root.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.Root.builder().optionallyWith(id.map(value => value: java.lang.String))(_.id).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(policyTypes.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.policyTypes).build()
  }
  def asReadOnly: Root.ReadOnly = Root.wrap(buildAwsValue())
}
object Root {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.Root] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Root = Root(idValue.map(value => value), arnValue.map(value => value), nameValue.map(value => value), policyTypesValue.map(value => value.map { item => 
      item.editable
    }))
    def idValue: scala.Option[primitives.RootId]
    def arnValue: scala.Option[primitives.RootArn]
    def nameValue: scala.Option[primitives.RootName]
    def policyTypesValue: scala.Option[List[PolicyTypeSummary.ReadOnly]]
    def id: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RootId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("id", idValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RootArn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RootName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def policyTypes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[PolicyTypeSummary.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("policyTypes", policyTypesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.Root) extends Root.ReadOnly {
    override def idValue: scala.Option[primitives.RootId] = scala.Option(impl.id()).map(value => value: primitives.RootId)
    override def arnValue: scala.Option[primitives.RootArn] = scala.Option(impl.arn()).map(value => value: primitives.RootArn)
    override def nameValue: scala.Option[primitives.RootName] = scala.Option(impl.name()).map(value => value: primitives.RootName)
    override def policyTypesValue: scala.Option[List[PolicyTypeSummary.ReadOnly]] = scala.Option(impl.policyTypes()).map(value => value.asScala.map { item => 
      PolicyTypeSummary.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.Root): ReadOnly = new Wrapper(impl)
}