package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListOrganizationalUnitsForParentResponse(organizationalUnits: scala.Option[Iterable[OrganizationalUnit]] = None, nextToken: scala.Option[primitives.NextToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentResponse = {
    import ListOrganizationalUnitsForParentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentResponse.builder().optionallyWith(organizationalUnits.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.organizationalUnits).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListOrganizationalUnitsForParentResponse.ReadOnly = ListOrganizationalUnitsForParentResponse.wrap(buildAwsValue())
}
object ListOrganizationalUnitsForParentResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListOrganizationalUnitsForParentResponse = ListOrganizationalUnitsForParentResponse(organizationalUnitsValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def organizationalUnitsValue: scala.Option[List[OrganizationalUnit.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.NextToken]
    def organizationalUnits: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[OrganizationalUnit.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("organizationalUnits", organizationalUnitsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentResponse) extends ListOrganizationalUnitsForParentResponse.ReadOnly {
    override def organizationalUnitsValue: scala.Option[List[OrganizationalUnit.ReadOnly]] = scala.Option(impl.organizationalUnits()).map(value => value.asScala.map { item => 
      OrganizationalUnit.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListOrganizationalUnitsForParentResponse): ReadOnly = new Wrapper(impl)
}