package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListCreateAccountStatusRequest(states: scala.Option[Iterable[CreateAccountState]] = None, nextToken: scala.Option[primitives.NextToken] = None, maxResults: scala.Option[primitives.MaxResults] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest = {
    import ListCreateAccountStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest.builder().optionallyWith(states.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.statesWithStrings).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: ListCreateAccountStatusRequest.ReadOnly = ListCreateAccountStatusRequest.wrap(buildAwsValue())
}
object ListCreateAccountStatusRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListCreateAccountStatusRequest = ListCreateAccountStatusRequest(statesValue.map(value => value), nextTokenValue.map(value => value), maxResultsValue.map(value => value))
    def statesValue: scala.Option[List[CreateAccountState]]
    def nextTokenValue: scala.Option[primitives.NextToken]
    def maxResultsValue: scala.Option[primitives.MaxResults]
    def states: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[CreateAccountState]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("states", statesValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResults] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest) extends ListCreateAccountStatusRequest.ReadOnly {
    override def statesValue: scala.Option[List[CreateAccountState]] = scala.Option(impl.states()).map(value => value.asScala.map { item => 
      CreateAccountState.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
    override def maxResultsValue: scala.Option[primitives.MaxResults] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResults)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListCreateAccountStatusRequest): ReadOnly = new Wrapper(impl)
}