package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdatePolicyResponse(policy: scala.Option[Policy] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.UpdatePolicyResponse = {
    import UpdatePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.UpdatePolicyResponse.builder().optionallyWith(policy.map(value => value.buildAwsValue()))(_.policy).build()
  }
  def asReadOnly: UpdatePolicyResponse.ReadOnly = UpdatePolicyResponse.wrap(buildAwsValue())
}
object UpdatePolicyResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.UpdatePolicyResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdatePolicyResponse = UpdatePolicyResponse(policyValue.map(value => value.editable))
    def policyValue: scala.Option[Policy.ReadOnly]
    def policy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Policy.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("policy", policyValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.UpdatePolicyResponse) extends UpdatePolicyResponse.ReadOnly { override def policyValue: scala.Option[Policy.ReadOnly] = scala.Option(impl.policy()).map(value => Policy.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.UpdatePolicyResponse): ReadOnly = new Wrapper(impl)
}