package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RemoveAccountFromOrganizationRequest(accountId: primitives.AccountId) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationRequest = {
    import RemoveAccountFromOrganizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationRequest.builder().accountId(accountId: java.lang.String).build()
  }
  def asReadOnly: RemoveAccountFromOrganizationRequest.ReadOnly = RemoveAccountFromOrganizationRequest.wrap(buildAwsValue())
}
object RemoveAccountFromOrganizationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RemoveAccountFromOrganizationRequest = RemoveAccountFromOrganizationRequest(accountIdValue)
    def accountIdValue: primitives.AccountId
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationRequest) extends RemoveAccountFromOrganizationRequest.ReadOnly { override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.RemoveAccountFromOrganizationRequest): ReadOnly = new Wrapper(impl)
}