package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait PolicyTypeStatus { def unwrap: software.amazon.awssdk.services.organizations.model.PolicyTypeStatus }
object PolicyTypeStatus {
  def wrap(value: software.amazon.awssdk.services.organizations.model.PolicyTypeStatus): PolicyTypeStatus = value match {
    case software.amazon.awssdk.services.organizations.model.PolicyTypeStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.organizations.model.PolicyTypeStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.organizations.model.PolicyTypeStatus.PENDING_ENABLE =>
      val r = PENDING_ENABLE
      r
    case software.amazon.awssdk.services.organizations.model.PolicyTypeStatus.PENDING_DISABLE =>
      val r = PENDING_DISABLE
      r
  }
  case object unknownToSdkVersion extends PolicyTypeStatus { override def unwrap: software.amazon.awssdk.services.organizations.model.PolicyTypeStatus = software.amazon.awssdk.services.organizations.model.PolicyTypeStatus.UNKNOWN_TO_SDK_VERSION }
  case object ENABLED extends PolicyTypeStatus { override def unwrap: software.amazon.awssdk.services.organizations.model.PolicyTypeStatus = software.amazon.awssdk.services.organizations.model.PolicyTypeStatus.ENABLED }
  case object PENDING_ENABLE extends PolicyTypeStatus { override def unwrap: software.amazon.awssdk.services.organizations.model.PolicyTypeStatus = software.amazon.awssdk.services.organizations.model.PolicyTypeStatus.PENDING_ENABLE }
  case object PENDING_DISABLE extends PolicyTypeStatus { override def unwrap: software.amazon.awssdk.services.organizations.model.PolicyTypeStatus = software.amazon.awssdk.services.organizations.model.PolicyTypeStatus.PENDING_DISABLE }
}