package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListParentsResponse(parents: scala.Option[Iterable[Parent]] = None, nextToken: scala.Option[primitives.NextToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListParentsResponse = {
    import ListParentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListParentsResponse.builder().optionallyWith(parents.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.parents).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListParentsResponse.ReadOnly = ListParentsResponse.wrap(buildAwsValue())
}
object ListParentsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListParentsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListParentsResponse = ListParentsResponse(parentsValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def parentsValue: scala.Option[List[Parent.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.NextToken]
    def parents: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Parent.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("parents", parentsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListParentsResponse) extends ListParentsResponse.ReadOnly {
    override def parentsValue: scala.Option[List[Parent.ReadOnly]] = scala.Option(impl.parents()).map(value => value.asScala.map { item => 
      Parent.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListParentsResponse): ReadOnly = new Wrapper(impl)
}