package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class EffectivePolicy(policyContent: scala.Option[primitives.PolicyContent] = None, lastUpdatedTimestamp: scala.Option[primitives.Timestamp] = None, targetId: scala.Option[primitives.PolicyTargetId] = None, policyType: scala.Option[EffectivePolicyType] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.EffectivePolicy = {
    import EffectivePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.EffectivePolicy.builder().optionallyWith(policyContent.map(value => value: java.lang.String))(_.policyContent).optionallyWith(lastUpdatedTimestamp.map(value => value: java.time.Instant))(_.lastUpdatedTimestamp).optionallyWith(targetId.map(value => value: java.lang.String))(_.targetId).optionallyWith(policyType.map(value => value.unwrap))(_.policyType).build()
  }
  def asReadOnly: EffectivePolicy.ReadOnly = EffectivePolicy.wrap(buildAwsValue())
}
object EffectivePolicy {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.EffectivePolicy] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: EffectivePolicy = EffectivePolicy(policyContentValue.map(value => value), lastUpdatedTimestampValue.map(value => value), targetIdValue.map(value => value), policyTypeValue.map(value => value))
    def policyContentValue: scala.Option[primitives.PolicyContent]
    def lastUpdatedTimestampValue: scala.Option[primitives.Timestamp]
    def targetIdValue: scala.Option[primitives.PolicyTargetId]
    def policyTypeValue: scala.Option[EffectivePolicyType]
    def policyContent: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PolicyContent] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("policyContent", policyContentValue)
    def lastUpdatedTimestamp: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Timestamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestampValue)
    def targetId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PolicyTargetId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("targetId", targetIdValue)
    def policyType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, EffectivePolicyType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("policyType", policyTypeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.EffectivePolicy) extends EffectivePolicy.ReadOnly {
    override def policyContentValue: scala.Option[primitives.PolicyContent] = scala.Option(impl.policyContent()).map(value => value: primitives.PolicyContent)
    override def lastUpdatedTimestampValue: scala.Option[primitives.Timestamp] = scala.Option(impl.lastUpdatedTimestamp()).map(value => value: primitives.Timestamp)
    override def targetIdValue: scala.Option[primitives.PolicyTargetId] = scala.Option(impl.targetId()).map(value => value: primitives.PolicyTargetId)
    override def policyTypeValue: scala.Option[EffectivePolicyType] = scala.Option(impl.policyType()).map(value => EffectivePolicyType.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.EffectivePolicy): ReadOnly = new Wrapper(impl)
}