package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeEffectivePolicyResponse(effectivePolicy: scala.Option[EffectivePolicy] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyResponse = {
    import DescribeEffectivePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyResponse.builder().optionallyWith(effectivePolicy.map(value => value.buildAwsValue()))(_.effectivePolicy).build()
  }
  def asReadOnly: DescribeEffectivePolicyResponse.ReadOnly = DescribeEffectivePolicyResponse.wrap(buildAwsValue())
}
object DescribeEffectivePolicyResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeEffectivePolicyResponse = DescribeEffectivePolicyResponse(effectivePolicyValue.map(value => value.editable))
    def effectivePolicyValue: scala.Option[EffectivePolicy.ReadOnly]
    def effectivePolicy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, EffectivePolicy.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("effectivePolicy", effectivePolicyValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyResponse) extends DescribeEffectivePolicyResponse.ReadOnly { override def effectivePolicyValue: scala.Option[EffectivePolicy.ReadOnly] = scala.Option(impl.effectivePolicy()).map(value => EffectivePolicy.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyResponse): ReadOnly = new Wrapper(impl)
}