package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeAccountRequest(accountId: primitives.AccountId) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.DescribeAccountRequest = {
    import DescribeAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribeAccountRequest.builder().accountId(accountId: java.lang.String).build()
  }
  def asReadOnly: DescribeAccountRequest.ReadOnly = DescribeAccountRequest.wrap(buildAwsValue())
}
object DescribeAccountRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.DescribeAccountRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeAccountRequest = DescribeAccountRequest(accountIdValue)
    def accountIdValue: primitives.AccountId
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.DescribeAccountRequest) extends DescribeAccountRequest.ReadOnly { override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.DescribeAccountRequest): ReadOnly = new Wrapper(impl)
}