package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class PolicySummary(id: scala.Option[primitives.PolicyId] = None, arn: scala.Option[primitives.PolicyArn] = None, name: scala.Option[primitives.PolicyName] = None, description: scala.Option[primitives.PolicyDescription] = None, `type`: scala.Option[PolicyType] = None, awsManaged: scala.Option[primitives.AwsManagedPolicy] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.PolicySummary = {
    import PolicySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.PolicySummary.builder().optionallyWith(id.map(value => value: java.lang.String))(_.id).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(description.map(value => value: java.lang.String))(_.description).optionallyWith(`type`.map(value => value.unwrap))(_.`type`).optionallyWith(awsManaged.map(value => value: java.lang.Boolean))(_.awsManaged).build()
  }
  def asReadOnly: PolicySummary.ReadOnly = PolicySummary.wrap(buildAwsValue())
}
object PolicySummary {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.PolicySummary] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: PolicySummary = PolicySummary(idValue.map(value => value), arnValue.map(value => value), nameValue.map(value => value), descriptionValue.map(value => value), typeValue.map(value => value), awsManagedValue.map(value => value))
    def idValue: scala.Option[primitives.PolicyId]
    def arnValue: scala.Option[primitives.PolicyArn]
    def nameValue: scala.Option[primitives.PolicyName]
    def descriptionValue: scala.Option[primitives.PolicyDescription]
    def typeValue: scala.Option[PolicyType]
    def awsManagedValue: scala.Option[primitives.AwsManagedPolicy]
    def id: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PolicyId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("id", idValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PolicyArn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PolicyName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PolicyDescription] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
    def `type`: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, PolicyType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("type", typeValue)
    def awsManaged: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsManagedPolicy] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsManaged", awsManagedValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.PolicySummary) extends PolicySummary.ReadOnly {
    override def idValue: scala.Option[primitives.PolicyId] = scala.Option(impl.id()).map(value => value: primitives.PolicyId)
    override def arnValue: scala.Option[primitives.PolicyArn] = scala.Option(impl.arn()).map(value => value: primitives.PolicyArn)
    override def nameValue: scala.Option[primitives.PolicyName] = scala.Option(impl.name()).map(value => value: primitives.PolicyName)
    override def descriptionValue: scala.Option[primitives.PolicyDescription] = scala.Option(impl.description()).map(value => value: primitives.PolicyDescription)
    override def typeValue: scala.Option[PolicyType] = scala.Option(impl.`type`()).map(value => PolicyType.wrap(value))
    override def awsManagedValue: scala.Option[primitives.AwsManagedPolicy] = scala.Option(impl.awsManaged()).map(value => value: primitives.AwsManagedPolicy)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.PolicySummary): ReadOnly = new Wrapper(impl)
}