package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Policy(policySummary: scala.Option[PolicySummary] = None, content: scala.Option[primitives.PolicyContent] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.Policy = {
    import Policy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.Policy.builder().optionallyWith(policySummary.map(value => value.buildAwsValue()))(_.policySummary).optionallyWith(content.map(value => value: java.lang.String))(_.content).build()
  }
  def asReadOnly: Policy.ReadOnly = Policy.wrap(buildAwsValue())
}
object Policy {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.Policy] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Policy = Policy(policySummaryValue.map(value => value.editable), contentValue.map(value => value))
    def policySummaryValue: scala.Option[PolicySummary.ReadOnly]
    def contentValue: scala.Option[primitives.PolicyContent]
    def policySummary: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, PolicySummary.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("policySummary", policySummaryValue)
    def content: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PolicyContent] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("content", contentValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.Policy) extends Policy.ReadOnly {
    override def policySummaryValue: scala.Option[PolicySummary.ReadOnly] = scala.Option(impl.policySummary()).map(value => PolicySummary.wrap(value))
    override def contentValue: scala.Option[primitives.PolicyContent] = scala.Option(impl.content()).map(value => value: primitives.PolicyContent)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.Policy): ReadOnly = new Wrapper(impl)
}