package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class OrganizationalUnit(id: scala.Option[primitives.OrganizationalUnitId] = None, arn: scala.Option[primitives.OrganizationalUnitArn] = None, name: scala.Option[primitives.OrganizationalUnitName] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.OrganizationalUnit = {
    import OrganizationalUnit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.OrganizationalUnit.builder().optionallyWith(id.map(value => value: java.lang.String))(_.id).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(name.map(value => value: java.lang.String))(_.name).build()
  }
  def asReadOnly: OrganizationalUnit.ReadOnly = OrganizationalUnit.wrap(buildAwsValue())
}
object OrganizationalUnit {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.OrganizationalUnit] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: OrganizationalUnit = OrganizationalUnit(idValue.map(value => value), arnValue.map(value => value), nameValue.map(value => value))
    def idValue: scala.Option[primitives.OrganizationalUnitId]
    def arnValue: scala.Option[primitives.OrganizationalUnitArn]
    def nameValue: scala.Option[primitives.OrganizationalUnitName]
    def id: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OrganizationalUnitId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("id", idValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OrganizationalUnitArn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OrganizationalUnitName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.OrganizationalUnit) extends OrganizationalUnit.ReadOnly {
    override def idValue: scala.Option[primitives.OrganizationalUnitId] = scala.Option(impl.id()).map(value => value: primitives.OrganizationalUnitId)
    override def arnValue: scala.Option[primitives.OrganizationalUnitArn] = scala.Option(impl.arn()).map(value => value: primitives.OrganizationalUnitArn)
    override def nameValue: scala.Option[primitives.OrganizationalUnitName] = scala.Option(impl.name()).map(value => value: primitives.OrganizationalUnitName)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.OrganizationalUnit): ReadOnly = new Wrapper(impl)
}