package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListAwsServiceAccessForOrganizationResponse(enabledServicePrincipals: scala.Option[Iterable[EnabledServicePrincipal]] = None, nextToken: scala.Option[primitives.NextToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationResponse = {
    import ListAwsServiceAccessForOrganizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationResponse.builder().optionallyWith(enabledServicePrincipals.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.enabledServicePrincipals).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListAwsServiceAccessForOrganizationResponse.ReadOnly = ListAwsServiceAccessForOrganizationResponse.wrap(buildAwsValue())
}
object ListAwsServiceAccessForOrganizationResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListAwsServiceAccessForOrganizationResponse = ListAwsServiceAccessForOrganizationResponse(enabledServicePrincipalsValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def enabledServicePrincipalsValue: scala.Option[List[EnabledServicePrincipal.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.NextToken]
    def enabledServicePrincipals: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[EnabledServicePrincipal.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enabledServicePrincipals", enabledServicePrincipalsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationResponse) extends ListAwsServiceAccessForOrganizationResponse.ReadOnly {
    override def enabledServicePrincipalsValue: scala.Option[List[EnabledServicePrincipal.ReadOnly]] = scala.Option(impl.enabledServicePrincipals()).map(value => value.asScala.map { item => 
      EnabledServicePrincipal.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListAwsServiceAccessForOrganizationResponse): ReadOnly = new Wrapper(impl)
}