package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class EnabledServicePrincipal(servicePrincipal: scala.Option[primitives.ServicePrincipal] = None, dateEnabled: scala.Option[primitives.Timestamp] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.EnabledServicePrincipal = {
    import EnabledServicePrincipal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.EnabledServicePrincipal.builder().optionallyWith(servicePrincipal.map(value => value: java.lang.String))(_.servicePrincipal).optionallyWith(dateEnabled.map(value => value: java.time.Instant))(_.dateEnabled).build()
  }
  def asReadOnly: EnabledServicePrincipal.ReadOnly = EnabledServicePrincipal.wrap(buildAwsValue())
}
object EnabledServicePrincipal {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.EnabledServicePrincipal] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: EnabledServicePrincipal = EnabledServicePrincipal(servicePrincipalValue.map(value => value), dateEnabledValue.map(value => value))
    def servicePrincipalValue: scala.Option[primitives.ServicePrincipal]
    def dateEnabledValue: scala.Option[primitives.Timestamp]
    def servicePrincipal: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ServicePrincipal] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("servicePrincipal", servicePrincipalValue)
    def dateEnabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Timestamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dateEnabled", dateEnabledValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.EnabledServicePrincipal) extends EnabledServicePrincipal.ReadOnly {
    override def servicePrincipalValue: scala.Option[primitives.ServicePrincipal] = scala.Option(impl.servicePrincipal()).map(value => value: primitives.ServicePrincipal)
    override def dateEnabledValue: scala.Option[primitives.Timestamp] = scala.Option(impl.dateEnabled()).map(value => value: primitives.Timestamp)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.EnabledServicePrincipal): ReadOnly = new Wrapper(impl)
}